/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric;

import dev.qixils.crowdcontrol.common.LoginData;
import dev.qixils.crowdcontrol.common.PlayerEntityMapper;
import dev.qixils.crowdcontrol.common.util.PermissionWrapper;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.relocated.annotations.NotNull;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.minecraft.class_1297;
import net.minecraft.class_3222;

public class ServerPlayerMapper
implements PlayerEntityMapper<class_3222> {
    protected final ModdedCrowdControlPlugin plugin;

    @Override
    @NotNull
    public Audience asAudience(@NotNull class_3222 entity) {
        return entity;
    }

    @Override
    @NotNull
    public Optional<UUID> tryGetUniqueId(@NotNull class_3222 entity) {
        return Optional.of(entity.method_5667());
    }

    @Override
    @NotNull
    public UUID getUniqueId(@NotNull class_3222 entity) {
        return entity.method_5667();
    }

    @Override
    public boolean hasPermission(@NotNull class_3222 entity, @NotNull PermissionWrapper perm) {
        return this.plugin.getPermissionUtil().check((class_1297)entity, perm);
    }

    @Override
    @NotNull
    public String getUsername(@NotNull class_3222 player) {
        return player.method_7334().getName();
    }

    @Override
    @NotNull
    public Optional<class_3222> getPlayer(@NotNull UUID uuid) {
        return Optional.ofNullable(this.plugin.getTheGame()).map(server -> server.method_68990().method_14602(uuid));
    }

    @Override
    @NotNull
    public Optional<class_3222> getPlayer(@NotNull InetAddress ip) {
        return Optional.ofNullable(this.plugin.getTheGame()).map(server -> {
            class_3222 result = null;
            for (class_3222 player : server.method_68990().method_14571()) {
                InetSocketAddress inetAddress;
                SocketAddress address;
                if (player.field_13987 == null || !((address = player.field_13987.method_48107()) instanceof InetSocketAddress) || !Objects.equals((inetAddress = (InetSocketAddress)address).getAddress(), ip)) continue;
                if (result != null) {
                    return null;
                }
                result = player;
            }
            return result;
        });
    }

    @Override
    @NotNull
    public Optional<class_3222> getPlayerByLogin(@NotNull LoginData login) {
        return Optional.ofNullable(this.plugin.getTheGame()).flatMap(server -> {
            for (class_3222 player : server.method_68990().method_14571()) {
                if (!player.method_7334().getName().equalsIgnoreCase(login.getName()) && !player.method_5667().equals(login.getId())) continue;
                return Optional.of(player);
            }
            return Optional.empty();
        });
    }

    @Override
    @NotNull
    public Optional<InetAddress> getIP(@NotNull class_3222 player) {
        return Optional.ofNullable(player.field_13987).map(connection -> {
            SocketAddress address = connection.method_48107();
            if (address instanceof InetSocketAddress) {
                InetSocketAddress inetAddress = (InetSocketAddress)address;
                return inetAddress.getAddress();
            }
            return null;
        });
    }

    public ModdedCrowdControlPlugin getPlugin() {
        return this.plugin;
    }

    public ServerPlayerMapper(ModdedCrowdControlPlugin plugin) {
        this.plugin = plugin;
    }
}

