/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.TriState;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.commands.KeepInventoryCommand;
import dev.qixils.crowdcontrol.plugin.fabric.utils.InventoryUtil;
import dev.qixils.relocated.annotations.NotNull;
import java.util.List;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.IUserRecord;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.minecraft.class_1297;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_3222;

public class ClearInventoryCommand
extends ModdedCommand {
    private final String effectName = "clear_inventory";

    public ClearInventoryCommand(ModdedCrowdControlPlugin plugin) {
        super(plugin);
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull class_3222>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            boolean success = false;
            for (class_3222 player : (List)playerSupplier.get()) {
                if (KeepInventoryCommand.isKeepingInventory((class_1297)player)) continue;
                class_1661 inv = player.method_31548();
                boolean hasItems = false;
                for (class_1799 item : InventoryUtil.viewAllItems(inv)) {
                    if (item.method_7960()) continue;
                    hasItems = true;
                    break;
                }
                if (!hasItems) continue;
                success = true;
                this.sync(() -> ((class_1661)inv).method_5448());
            }
            return success ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "All inventories are already empty or protected");
        }));
    }

    @Override
    public TriState isVisible(@NotNull IUserRecord user, @NotNull List<class_3222> potentialPlayers) {
        return potentialPlayers.stream().anyMatch(player -> player.method_51469().method_64395().method_8355(class_1928.field_19389)) ? TriState.FALSE : TriState.TRUE;
    }

    @Override
    public TriState isSelectable(@NotNull IUserRecord user, @NotNull List<class_3222> potentialPlayers) {
        if (this.plugin.isGlobal()) {
            return KeepInventoryCommand.globalKeepInventory ? TriState.FALSE : TriState.TRUE;
        }
        TriState keepingInventory = potentialPlayers.stream().map(player -> TriState.fromBoolean(KeepInventoryCommand.isKeepingInventory(player.method_5667()))).reduce((prev, next) -> {
            if (prev != next) {
                return TriState.UNKNOWN;
            }
            return prev;
        }).orElse(TriState.UNKNOWN);
        if (keepingInventory == TriState.TRUE) {
            return TriState.FALSE;
        }
        return TriState.TRUE;
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }
}

