/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.utils.AttributeUtil;
import dev.qixils.relocated.annotations.NotNull;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.CCTimedEffect;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCTimedEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.minecraft.class_6880;

public class GravityCommand
extends ModdedCommand
implements CCTimedEffect {
    private final String effectName;
    private final double gravityLevel;
    private final double fallLevel;
    private final double fallDmgLevel;
    private final List<String> effectGroups = Arrays.asList("gravity", "walk");
    private final Map<UUID, List<UUID>> idMap = new HashMap<UUID, List<UUID>>();

    private GravityCommand(ModdedCrowdControlPlugin plugin, String effectName, double gravityLevel, double fallLevel, double fallDmgLevel) {
        super(plugin);
        this.effectName = effectName;
        this.gravityLevel = gravityLevel;
        this.fallLevel = fallLevel;
        this.fallDmgLevel = fallDmgLevel;
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull class_3222>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            if (this.isActive(ccPlayer, this.getEffectArray())) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Cannot change gravity while frozen");
            }
            List players = (List)playerSupplier.get();
            this.idMap.put(request.getRequestId(), players.stream().map(class_1297::method_5667).toList());
            for (class_3222 player : players) {
                AttributeUtil.addModifier((class_1309)player, (class_6880<class_1320>)class_5134.field_49078, CommandConstants.GRAVITY_MODIFIER_UUID, this.gravityLevel, class_1322.class_1323.field_6330, false);
                AttributeUtil.addModifier((class_1309)player, (class_6880<class_1320>)class_5134.field_49079, CommandConstants.FALL_MODIFIER_UUID, this.fallLevel, class_1322.class_1323.field_6330, false);
                AttributeUtil.addModifier((class_1309)player, (class_6880<class_1320>)class_5134.field_49077, CommandConstants.FALL_DMG_MODIFIER_UUID, this.fallDmgLevel, class_1322.class_1323.field_6328, false);
            }
            return new CCTimedEffectResponse(request.getRequestId(), ResponseStatus.TIMED_BEGIN, request.getEffect().getDurationMillis());
        }));
    }

    @Override
    public void onEnd(@NotNull PublicEffectPayload request, @NotNull CCPlayer source) {
        for (class_3222 player : this.plugin.toPlayerList((Collection<UUID>)this.idMap.remove(request.getRequestId()))) {
            AttributeUtil.removeModifier((class_1309)player, (class_6880<class_1320>)class_5134.field_49078, CommandConstants.GRAVITY_MODIFIER_UUID);
            AttributeUtil.removeModifier((class_1309)player, (class_6880<class_1320>)class_5134.field_49079, CommandConstants.FALL_MODIFIER_UUID);
        }
    }

    @NotNull
    public static GravityCommand zero(ModdedCrowdControlPlugin plugin) {
        return new GravityCommand(plugin, "zero_gravity", -1.0, 0.0, 0.0);
    }

    @NotNull
    public static GravityCommand low(ModdedCrowdControlPlugin plugin) {
        return new GravityCommand(plugin, "low_gravity", -0.5, 1.0, -0.5);
    }

    @NotNull
    public static GravityCommand high(ModdedCrowdControlPlugin plugin) {
        return new GravityCommand(plugin, "high_gravity", 1.0, -0.5, 1.0);
    }

    @NotNull
    public static GravityCommand maximum(ModdedCrowdControlPlugin plugin) {
        return new GravityCommand(plugin, "maximum_gravity", 3.0, -1.0, 3.0);
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }

    public double getGravityLevel() {
        return this.gravityLevel;
    }

    public double getFallLevel() {
        return this.fallLevel;
    }

    public double getFallDmgLevel() {
        return this.fallDmgLevel;
    }

    @Override
    public List<String> getEffectGroups() {
        return this.effectGroups;
    }

    public Map<UUID, List<UUID>> getIdMap() {
        return this.idMap;
    }
}

