/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import com.google.common.collect.Lists;
import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.common.util.RandomUtil;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.common.util.Weighted;
import dev.qixils.crowdcontrol.common.util.sound.Sounds;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.utils.AttributeUtil;
import dev.qixils.relocated.annotations.Contract;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1707;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3902;
import net.minecraft.class_3908;
import net.minecraft.class_5134;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_747;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9290;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9701;

public class LootboxCommand
extends ModdedCommand {
    private static final List<class_6880<class_1320>> ATTRIBUTES = Arrays.asList(class_5134.field_23716, class_5134.field_23718, class_5134.field_23719, class_5134.field_23721, class_5134.field_23724, class_5134.field_23725, class_5134.field_23722, class_5134.field_23723);
    private static final List<class_9331<?>> CURSES = List.of(class_9701.field_51656, class_9701.field_51655);
    private static final Map<class_1304, class_9274> SLOT_TO_GROUP = Map.of(class_1304.field_6173, class_9274.field_49217, class_1304.field_6171, class_9274.field_49218, class_1304.field_6169, class_9274.field_49223, class_1304.field_6174, class_9274.field_49222, class_1304.field_6172, class_9274.field_49221, class_1304.field_6166, class_9274.field_49220);
    public static final Map<UUID, class_1707> OPEN_LOOTBOXES = new HashMap<UUID, class_1707>();
    public static final Map<UUID, class_2561> TITLES = new HashMap<UUID, class_2561>();
    private final List<class_1792> allItems;
    private final List<class_1792> goodItems;
    private final String effectName;
    private final int luck;

    public LootboxCommand(ModdedCrowdControlPlugin plugin, int luck) {
        super(plugin);
        this.luck = luck;
        StringBuilder effectName = new StringBuilder("lootbox");
        if (luck > 0) {
            effectName.append('_').append(luck);
        }
        this.effectName = effectName.toString();
        this.allItems = class_7923.field_41178.method_10220().filter(it -> it != class_1802.field_8162).toList();
        this.goodItems = this.allItems.stream().filter(itemType -> (Integer)itemType.method_57347().method_58695(class_9334.field_50072, (Object)0) > 1 || itemType == class_1802.field_8463 || itemType == class_1802.field_8367 || itemType == class_1802.field_22018 || itemType == class_1802.field_8603 || itemType == class_1802.field_8773 || itemType == class_1802.field_8494).collect(Collectors.toList());
    }

    private static boolean isLootboxOpen(@NotNull class_1657 player) {
        UUID uuid = player.method_5667();
        if (!OPEN_LOOTBOXES.containsKey(uuid)) {
            return false;
        }
        class_1707 inv = OPEN_LOOTBOXES.get(uuid);
        if (inv.method_7629().method_5442() || !inv.method_7597(player) || player.field_7512 != inv) {
            OPEN_LOOTBOXES.remove(uuid);
            return false;
        }
        return true;
    }

    public static void onInventoryClose(class_3222 player) {
        if (!ModdedCrowdControlPlugin.isInstanceAvailable()) {
            return;
        }
        ModdedCrowdControlPlugin plugin = ModdedCrowdControlPlugin.getInstance();
        UUID uuid = player.method_5667();
        if (!LootboxCommand.isLootboxOpen((class_1657)player)) {
            return;
        }
        class_1707 lootbox = OPEN_LOOTBOXES.get(uuid);
        plugin.getSyncExecutor().execute(() -> {
            OptionalInt status = player.method_17355((class_3908)new class_747((i, inventory, p) -> class_1707.method_19245((int)i, (class_1661)inventory, (class_1263)lootbox.method_7629()), TITLES.get(uuid)));
            if (status.isEmpty()) {
                OPEN_LOOTBOXES.remove(uuid);
            }
            OPEN_LOOTBOXES.put(uuid, (class_1707)player.field_7512);
        });
    }

    private boolean isGoodItem(@Nullable class_1792 item) {
        return item != null && this.goodItems.contains(item);
    }

    public class_1799 createRandomItem(int luck, @Nullable class_5455 registryAccess) {
        ArrayList<class_1792> items = new ArrayList<class_1792>(this.allItems);
        items.removeIf(this.plugin::isDisabled);
        Collections.shuffle(items, random);
        class_1792 item = null;
        for (int i = 0; i <= luck * 5; ++i) {
            class_1792 oldItem = item;
            item = (class_1792)items.get(i);
            if (this.isGoodItem(item) && !this.isGoodItem(oldItem)) break;
        }
        assert (item != null);
        int quantity = 1;
        int maxStackSize = (Integer)item.method_57347().method_58695(class_9334.field_50071, (Object)0);
        if (maxStackSize > 1) {
            for (int i = 0; i <= luck; ++i) {
                quantity = Math.max(quantity, RandomUtil.nextInclusiveInt(1, maxStackSize));
            }
        }
        class_1799 itemStack = new class_1799((class_1935)item, quantity);
        this.randomlyModifyItem(itemStack, luck, registryAccess);
        return itemStack;
    }

    @Contract(mutates="param1")
    public void randomlyModifyItem(class_1799 itemStack, int luck, @Nullable class_5455 registryAccess) {
        if (registryAccess == null) {
            registryAccess = this.plugin.theGame().method_69003();
        }
        if (random.nextDouble() >= 0.95 - (double)luck * 0.1) {
            itemStack.method_57379(class_9334.field_49630, (Object)class_3902.field_17274);
        }
        if (random.nextInt(4) == 0) {
            itemStack.method_57379(class_9334.field_49607, (Object)new class_8053((class_6880)RandomUtil.randomElementFrom(this.plugin.registryHolders(class_7924.field_42083, registryAccess)), (class_6880)RandomUtil.randomElementFrom(this.plugin.registryHolders(class_7924.field_42082, registryAccess))));
        }
        int _enchantments = 0;
        for (int i = 0; i <= luck; ++i) {
            _enchantments = Math.max(_enchantments, ((CommandConstants.EnchantmentWeights)RandomUtil.weightedRandom((Weighted[])CommandConstants.EnchantmentWeights.values(), (int)CommandConstants.EnchantmentWeights.TOTAL_WEIGHTS)).getLevel());
        }
        int enchantments = _enchantments;
        List enchantmentList = this.plugin.registry(class_7924.field_41265, registryAccess).method_42017().filter(enchantmentHolder -> ((class_1887)enchantmentHolder.comp_349()).method_8192(itemStack)).collect(Collectors.toList());
        if (random.nextDouble() >= 0.8 - (double)luck * 0.2) {
            for (class_9331<?> curse : CURSES) {
                enchantmentList.removeIf(holder -> ((class_1887)holder.comp_349()).comp_2689().method_57832(curse));
            }
        }
        ArrayList<class_6880> addedEnchantments = new ArrayList<class_6880>(enchantments);
        while (addedEnchantments.size() < enchantments && !enchantmentList.isEmpty()) {
            class_6880 enchantment = (class_6880)enchantmentList.removeFirst();
            if (addedEnchantments.stream().anyMatch(x -> class_1887.method_60033((class_6880)x, (class_6880)enchantment)) && random.nextDouble() >= 0.1 + (double)luck * 0.1) continue;
            addedEnchantments.add(enchantment);
            int level = ((class_1887)enchantment.comp_349()).method_8187();
            if (((class_1887)enchantment.comp_349()).method_8183() > level) {
                for (int j = 0; j <= luck; ++j) {
                    level = Math.max(level, RandomUtil.nextInclusiveInt(((class_1887)enchantment.comp_349()).method_8187(), ((class_1887)enchantment.comp_349()).method_8183()));
                }
                if (random.nextDouble() >= 0.5 - (double)luck * 0.07) {
                    level += random.nextInt(4);
                }
            }
            itemStack.method_7978(enchantment, level);
        }
        int attributes = 0;
        for (int i = 0; i <= luck; ++i) {
            attributes = Math.max(attributes, ((CommandConstants.AttributeWeights)RandomUtil.weightedRandom((Weighted[])CommandConstants.AttributeWeights.values(), (int)CommandConstants.AttributeWeights.TOTAL_WEIGHTS)).getLevel());
        }
        if (attributes > 0) {
            ArrayList<class_6880<class_1320>> attributeList = new ArrayList<class_6880<class_1320>>(ATTRIBUTES);
            Collections.shuffle(attributeList, random);
            for (int i = 0; i < attributeList.size() && i < attributes; ++i) {
                class_6880 attribute = (class_6880)attributeList.get(i);
                double amount = 0.0;
                for (int j = 0; j <= luck; ++j) {
                    amount = Math.max(amount, random.nextDouble() * 2.0 - 1.0);
                }
                class_1322 attributeModifier = new class_1322(AttributeUtil.migrateId(UUID.randomUUID()), amount, class_1322.class_1323.field_6328);
                class_9285 modifiers = (class_9285)itemStack.method_58695(class_9334.field_49636, (Object)class_9285.field_49326);
                modifiers = modifiers.method_57484(attribute, attributeModifier, class_9274.field_49216);
                itemStack.method_57379(class_9334.field_49636, (Object)modifiers);
            }
        }
    }

    private List<Component> getLore(class_1799 itemStack) {
        class_9290 itemLore = (class_9290)itemStack.method_58694(class_9334.field_49632);
        if (itemLore == null || itemLore.comp_2400().isEmpty()) {
            return new ArrayList<Component>();
        }
        return itemLore.comp_2400().stream().map(this.plugin::toAdventure).collect(Collectors.toList());
    }

    private void setLore(class_1799 itemStack, List<Component> lore) {
        if (lore.isEmpty()) {
            itemStack.method_57381(class_9334.field_49632);
            return;
        }
        List nativeLore = Lists.transform(lore, component -> this.plugin.adventure().asNative(component));
        itemStack.method_57379(class_9334.field_49632, (Object)new class_9290(nativeLore));
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull class_3222>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            boolean success = false;
            List players = (List)playerSupplier.get();
            for (class_3222 player : players) {
                if (LootboxCommand.isLootboxOpen((class_1657)player)) continue;
                class_1277 container = new class_1277(27);
                for (int slot : CommandConstants.lootboxItemSlots(this.luck)) {
                    class_1799 itemStack = this.createRandomItem(this.luck, player.method_56673());
                    List<Component> lore = this.getLore(itemStack);
                    lore.add(this.plugin.adventure().renderer().render(CommandConstants.buildLootboxLore(this.plugin, request), (Object)player));
                    this.setLore(itemStack, lore);
                    container.method_5447(slot, itemStack);
                }
                class_2561 title = this.plugin.adventure().asNative(CommandConstants.buildLootboxTitle(this.plugin, request));
                OptionalInt val = player.method_17355((class_3908)new class_747((i, inventory, p) -> class_1707.method_19245((int)i, (class_1661)inventory, (class_1263)container), title));
                if (val.isEmpty()) continue;
                player.playSound(Sounds.LOOTBOX_CHIME.get(this.luck), Sound.Emitter.self());
                OPEN_LOOTBOXES.put(player.method_5667(), (class_1707)player.field_7512);
                TITLES.put(player.method_5667(), title);
                success = true;
            }
            return success ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Player has another lootbox open");
        }, this.plugin.getSyncExecutor()));
    }

    public List<class_1792> getAllItems() {
        return this.allItems;
    }

    public List<class_1792> getGoodItems() {
        return this.goodItems;
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }

    public int getLuck() {
        return this.luck;
    }
}

