/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.utils.AttributeUtil;
import dev.qixils.relocated.annotations.NotNull;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.CCTimedEffect;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCTimedEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.minecraft.class_6880;

public class PlayerSizeCommand
extends ModdedCommand
implements CCTimedEffect {
    private final Map<UUID, Set<UUID>> idMap = new HashMap<UUID, Set<UUID>>();
    private final String effectName;
    private final double level;
    private final String effectGroup = "gravity";
    private final List<String> effectGroups = Collections.singletonList("gravity");

    public PlayerSizeCommand(ModdedCrowdControlPlugin plugin, String effectName, double level) {
        super(plugin);
        this.effectName = effectName;
        this.level = level;
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull class_3222>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            if (this.isArrayActive(ccPlayer)) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Conflicting effects active");
            }
            List players = (List)playerSupplier.get();
            this.idMap.put(request.getRequestId(), players.stream().map(class_1297::method_5667).collect(Collectors.toSet()));
            for (class_3222 player : players) {
                AttributeUtil.addModifier((class_1309)player, (class_6880<class_1320>)class_5134.field_47760, CommandConstants.SCALE_MODIFIER_UUID, this.level, class_1322.class_1323.field_6330, false);
                AttributeUtil.addModifier((class_1309)player, (class_6880<class_1320>)class_5134.field_47761, CommandConstants.SCALE_STEP_MODIFIER_UUID, this.level, class_1322.class_1323.field_6330, false);
                AttributeUtil.addModifier((class_1309)player, (class_6880<class_1320>)class_5134.field_23728, CommandConstants.SCALE_JUMP_MODIFIER_UUID, this.level, class_1322.class_1323.field_6330, false);
                AttributeUtil.addModifier((class_1309)player, (class_6880<class_1320>)class_5134.field_49079, CommandConstants.FALL_MODIFIER_UUID, this.level, class_1322.class_1323.field_6330, false);
            }
            return new CCTimedEffectResponse(request.getRequestId(), ResponseStatus.TIMED_BEGIN, request.getEffect().getDurationMillis());
        }));
    }

    @Override
    public void onEnd(@NotNull PublicEffectPayload request, @NotNull CCPlayer source) {
        this.plugin.toPlayerStream((Collection<UUID>)this.idMap.remove(request.getRequestId())).forEach(player -> {
            AttributeUtil.removeModifier((class_1309)player, (class_6880<class_1320>)class_5134.field_47760, CommandConstants.SCALE_MODIFIER_UUID);
            AttributeUtil.removeModifier((class_1309)player, (class_6880<class_1320>)class_5134.field_47761, CommandConstants.SCALE_STEP_MODIFIER_UUID);
            AttributeUtil.removeModifier((class_1309)player, (class_6880<class_1320>)class_5134.field_23728, CommandConstants.SCALE_JUMP_MODIFIER_UUID);
            AttributeUtil.removeModifier((class_1309)player, (class_6880<class_1320>)class_5134.field_49079, CommandConstants.FALL_MODIFIER_UUID);
        });
    }

    public static PlayerSizeCommand increase(ModdedCrowdControlPlugin plugin) {
        return new PlayerSizeCommand(plugin, "player_size_double", 1.0);
    }

    public static PlayerSizeCommand decrease(ModdedCrowdControlPlugin plugin) {
        return new PlayerSizeCommand(plugin, "player_size_halve", -0.5);
    }

    public Map<UUID, Set<UUID>> getIdMap() {
        return this.idMap;
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }

    public double getLevel() {
        return this.level;
    }

    public String getEffectGroup() {
        return this.effectGroup;
    }

    @Override
    public List<String> getEffectGroups() {
        return this.effectGroups;
    }
}

