/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.event;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventRegister<T> {
    private static final Logger log = LoggerFactory.getLogger(EventRegister.class);
    private final List<Consumer<T>> listeners = new ArrayList<Consumer<T>>();

    public void fire(T event) {
        for (Consumer<T> listener : this.listeners) {
            try {
                listener.accept(event);
            }
            catch (Exception e) {
                log.warn("Consumer {} failed to accept event {}", (Object)listener.getClass(), (Object)event);
            }
        }
    }

    public void register(Consumer<T> listener) {
        this.listeners.add(listener);
    }
}

