/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.relocated.configurate.serialize;

import dev.qixils.relocated.configurate.serialize.CoercionFailedException;
import dev.qixils.relocated.configurate.serialize.ScalarSerializer;
import dev.qixils.relocated.configurate.serialize.SerializationException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Predicate;

final class UriSerializer
extends ScalarSerializer<URI> {
    UriSerializer() {
        super(URI.class);
    }

    @Override
    public URI deserialize(Type type, Object obj) throws SerializationException {
        String plainUri = obj.toString();
        try {
            return new URI(plainUri);
        }
        catch (URISyntaxException e) {
            throw new CoercionFailedException(obj, "URI");
        }
    }

    @Override
    public Object serialize(URI item, Predicate<Class<?>> typeSupported) {
        return item.toString();
    }
}

