/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.common;

import dev.qixils.crowdcontrol.common.EntityMapper;
import dev.qixils.crowdcontrol.common.LoginData;
import dev.qixils.relocated.annotations.CheckReturnValue;
import dev.qixils.relocated.annotations.NotNull;
import java.net.InetAddress;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.identity.Identity;

public interface PlayerEntityMapper<P>
extends EntityMapper<P> {
    @CheckReturnValue
    @NotNull
    default public String getUsername(@NotNull P player) {
        return (String)this.asAudience(player).get(Identity.NAME).orElseThrow(() -> new UnsupportedOperationException("Player object does not support Identity.NAME"));
    }

    @CheckReturnValue
    @NotNull
    public Optional<P> getPlayer(@NotNull UUID var1);

    @CheckReturnValue
    @NotNull
    default public UUID getUniqueId(@NotNull P entity) {
        return this.tryGetUniqueId(entity).orElseThrow(() -> new UnsupportedOperationException("Player object does not support UUID"));
    }

    @CheckReturnValue
    @NotNull
    public Optional<P> getPlayer(@NotNull InetAddress var1);

    @CheckReturnValue
    @NotNull
    default public Optional<P> getPlayerByLogin(@NotNull String login) {
        return this.getPlayerByLogin(new LoginData(login));
    }

    @CheckReturnValue
    @NotNull
    public Optional<P> getPlayerByLogin(@NotNull LoginData var1);

    @CheckReturnValue
    @NotNull
    public Optional<InetAddress> getIP(@NotNull P var1);
}

