/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.common;

import dev.qixils.crowdcontrol.common.Plugin;
import dev.qixils.crowdcontrol.common.util.OptionalUtil;
import dev.qixils.relocated.annotations.CheckReturnValue;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import live.crowdcontrol.cc4j.IUserRecord;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;

public interface PlayerManager<P> {
    @CheckReturnValue
    @NotNull
    public Plugin<P, ?> getPlugin();

    public boolean canApply(@NotNull P var1, @Nullable PublicEffectPayload var2);

    public boolean isSpectator(@NotNull P var1);

    @CheckReturnValue
    @NotNull
    public @NotNull List<@NotNull P> getAllPlayersFull();

    default public Stream<P> getPotentialPlayers(@NotNull IUserRecord user) {
        if (this.getPlugin().isGlobal()) {
            return this.getAllPlayersFull().stream();
        }
        return OptionalUtil.stream(this.getPlugin().optionalCrowdControl()).flatMap(cc -> cc.getPlayerIds(user.getId()).stream()).flatMap(uuid -> OptionalUtil.stream(this.getPlugin().playerMapper().getPlayer((UUID)uuid)));
    }

    @CheckReturnValue
    @NotNull
    default public @NotNull Stream<@NotNull P> getPlayers(@NotNull PublicEffectPayload request) {
        return this.getPotentialPlayers(request.getTarget()).filter(player -> this.canApply(player, request));
    }

    @CheckReturnValue
    @NotNull
    default public @NotNull Stream<@NotNull P> getAllPlayers(@Nullable PublicEffectPayload request) {
        return this.getAllPlayersFull().stream().filter(player -> this.canApply(player, request));
    }

    @NotNull
    default public @NotNull Stream<@NotNull P> getSpectators() {
        return this.getAllPlayersFull().stream().filter(this::isSpectator);
    }
}

