/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.common;

import dev.qixils.crowdcontrol.TrackedEffect;
import dev.qixils.crowdcontrol.TriState;
import dev.qixils.crowdcontrol.common.EntityMapper;
import dev.qixils.crowdcontrol.common.HideNames;
import dev.qixils.crowdcontrol.common.KyoriTranslator;
import dev.qixils.crowdcontrol.common.LimitConfig;
import dev.qixils.crowdcontrol.common.PlayerEntityMapper;
import dev.qixils.crowdcontrol.common.PlayerManager;
import dev.qixils.crowdcontrol.common.SoftLockConfig;
import dev.qixils.crowdcontrol.common.VersionMetadata;
import dev.qixils.crowdcontrol.common.command.AbstractCommandRegister;
import dev.qixils.crowdcontrol.common.command.Command;
import dev.qixils.crowdcontrol.common.mc.MCCCPlayer;
import dev.qixils.crowdcontrol.common.packets.util.ExtraFeature;
import dev.qixils.crowdcontrol.common.util.Application;
import dev.qixils.crowdcontrol.common.util.CollectionUtil;
import dev.qixils.crowdcontrol.common.util.OptionalUtil;
import dev.qixils.crowdcontrol.common.util.PermissionWrapper;
import dev.qixils.crowdcontrol.common.util.SemVer;
import dev.qixils.crowdcontrol.common.util.TextUtil;
import dev.qixils.crowdcontrol.exceptions.ExceptionUtil;
import dev.qixils.relocated.annotations.ApiStatus;
import dev.qixils.relocated.annotations.CheckReturnValue;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import live.crowdcontrol.cc4j.CCEventType;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.CrowdControl;
import live.crowdcontrol.cc4j.IUserRecord;
import live.crowdcontrol.cc4j.websocket.UserToken;
import live.crowdcontrol.cc4j.websocket.data.CCEffectReport;
import live.crowdcontrol.cc4j.websocket.data.IdentifierType;
import live.crowdcontrol.cc4j.websocket.data.ReportStatus;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.CCEffectDescription;
import live.crowdcontrol.cc4j.websocket.payload.CCName;
import live.crowdcontrol.cc4j.websocket.payload.CCUserRecord;
import live.crowdcontrol.cc4j.websocket.payload.ProfileType;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.translation.GlobalTranslator;
import net.kyori.adventure.translation.Translator;
import org.incendo.cloud.Command;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.description.Description;
import org.incendo.cloud.minecraft.extras.MinecraftExceptionHandler;
import org.incendo.cloud.parser.standard.StringParser;
import org.incendo.cloud.permission.PredicatePermission;
import org.incendo.cloud.suggestion.Suggestion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Plugin<P, S> {
    public static final TextColor JOIN_MESSAGE_COLOR = TextColor.color((int)16574932);
    public static final TextColor USER_COLOR = TextColor.color((int)10437851);
    public static final TextColor CMD_COLOR = TextColor.color((int)11623395);
    public static final TextColor DIM_CMD_COLOR = TextColor.color((int)11109058);
    public static final TextColor _ERROR_COLOR = TextColor.color((int)16220288);
    public static final String PREFIX = "CrowdControl";
    public static final String NAMESPACE = "crowdcontrol";
    public static final Key VERSION_REQUEST_KEY = Key.key((String)"crowdcontrol", (String)"version-request");
    public static final Key VERSION_RESPONSE_KEY = Key.key((String)"crowdcontrol", (String)"version-response");
    public static final Key SHADER_KEY = Key.key((String)"crowdcontrol", (String)"shader");
    public static final Key MOVEMENT_STATUS_KEY = Key.key((String)"crowdcontrol", (String)"movement-status");
    public static final Key EXTRA_FEATURE_KEY = Key.key((String)"crowdcontrol", (String)"extra-feature");
    public static final Key SET_LANGUAGE_KEY = Key.key((String)"crowdcontrol", (String)"set-language");
    public static final Component PREFIX_COMPONENT = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((char)'[', (TextColor)NamedTextColor.DARK_GRAY, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)"CrowdControl", (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((char)']', (TextColor)NamedTextColor.DARK_GRAY, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).appendSpace()).build();
    public static final Component VIEWER_NAME = Component.translatable((String)"cc.effect.viewer");
    public static final PermissionWrapper USE_PERMISSION = PermissionWrapper.builder().node("crowdcontrol.use").description("Whether a player is allowed to receive effects").defaultPermission(PermissionWrapper.DefaultPermission.ALL).build();
    public static final PermissionWrapper ADMIN_PERMISSION = PermissionWrapper.builder().node("crowdcontrol.admin").description("Whether a player is allowed to use administrative commands").defaultPermission(PermissionWrapper.DefaultPermission.OP).build();
    public static final Component JOIN_MESSAGE = Component.translatable((String)"cc.join.info", (TextColor)JOIN_MESSAGE_COLOR, (ComponentLike[])new ComponentLike[]{Component.text((String)"Crowd Control", (TextColor)TextColor.color((int)16441600)), ((TextComponent)((TextComponent)Component.text((String)"qi", (TextColor)TextColor.color((int)16762805)).append((Component)Component.text((String)"xi", (TextColor)TextColor.color((int)16768714)))).append((Component)Component.text((String)"ls", (TextColor)TextColor.color((int)16764650)))).append((Component)Component.text((String)".dev", (TextColor)TextColor.color((int)16758757))), Component.text((String)"crowdcontrol.live", (TextColor)TextColor.color((int)16441600))});
    public static final Component NO_GLOBAL_EFFECTS_MESSAGE = Plugin.warning((Component)Component.translatable((String)"cc.error.no-global-effects", (ComponentLike[])new ComponentLike[]{Component.text((String)"global", (TextColor)TextColor.color((int)16362910)), Component.text((String)"true", (TextColor)TextColor.color((int)16362910)), Component.text((String)"hosts", (TextColor)TextColor.color((int)16362910))}));
    @NotNull
    protected final Class<P> playerClass;
    @NotNull
    protected final Class<S> commandSenderClass;
    @Nullable
    protected CrowdControl crowdControl = null;
    protected boolean global = false;
    protected boolean announce = true;
    @NotNull
    protected HideNames hideNames = HideNames.NONE;
    @NotNull
    protected Collection<String> hosts = Collections.emptySet();
    @NotNull
    protected LimitConfig limitConfig = new LimitConfig();
    @NotNull
    protected SoftLockConfig softLockConfig = new SoftLockConfig();
    @NotNull
    protected final ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(2);
    protected final Map<UUID, SemVer> clientVersions = new HashMap<UUID, SemVer>();
    protected final Map<UUID, Set<ExtraFeature>> extraFeatures = new HashMap<UUID, Set<ExtraFeature>>();
    protected final Map<UUID, TrackedEffect> trackedEffects = new HashMap<UUID, TrackedEffect>();

    @NotNull
    public static Component error(@NotNull Component text) {
        if (text.decoration(TextDecoration.BOLD) == TextDecoration.State.NOT_SET) {
            text = text.decoration(TextDecoration.BOLD, false);
        }
        return Component.translatable((String)"cc.error.prefix.critical", (TextColor)NamedTextColor.RED, EnumSet.of(TextDecoration.BOLD), (ComponentLike[])new ComponentLike[]{text.colorIfAbsent(_ERROR_COLOR)});
    }

    @NotNull
    public static Component warning(@NotNull Component text) {
        if (text.decoration(TextDecoration.BOLD) == TextDecoration.State.NOT_SET) {
            text = text.decoration(TextDecoration.BOLD, false);
        }
        return Component.translatable((String)"cc.error.prefix.warning", (TextColor)NamedTextColor.RED, EnumSet.of(TextDecoration.BOLD), (ComponentLike[])new ComponentLike[]{text.colorIfAbsent(_ERROR_COLOR)});
    }

    @NotNull
    public static Component output(@NotNull Component text) {
        return PREFIX_COMPONENT.append(text);
    }

    protected Plugin(@NotNull Class<P> playerClass, @NotNull Class<S> commandSenderClass) {
        this.playerClass = playerClass;
        this.commandSenderClass = commandSenderClass;
    }

    @Nullable
    @CheckReturnValue
    public CrowdControl getCrowdControl() {
        return this.crowdControl;
    }

    @NotNull
    @CheckReturnValue
    public Class<P> getPlayerClass() {
        return this.playerClass;
    }

    @NotNull
    @CheckReturnValue
    public Class<S> getCommandSenderClass() {
        return this.commandSenderClass;
    }

    @CheckReturnValue
    public boolean isGlobal() {
        return this.global;
    }

    @CheckReturnValue
    @NotNull
    public Collection<String> getHosts() {
        return this.hosts;
    }

    @CheckReturnValue
    public boolean announceEffects() {
        return this.announce;
    }

    public void setAnnounceEffects(boolean announceEffects) {
        this.announce = announceEffects;
    }

    @NotNull
    public ScheduledExecutorService getScheduledExecutor() {
        return this.scheduledExecutor;
    }

    @NotNull
    public HideNames getHideNames() {
        return this.hideNames;
    }

    public void setHideNames(@NotNull HideNames hideNames) {
        this.hideNames = hideNames;
    }

    @NotNull
    public LimitConfig getLimitConfig() {
        return this.limitConfig;
    }

    @NotNull
    public SoftLockConfig getSoftLockConfig() {
        return this.softLockConfig;
    }

    public abstract PlayerEntityMapper<P> playerMapper();

    public abstract EntityMapper<S> commandSenderMapper();

    @NotNull
    @CheckReturnValue
    public abstract PlayerManager<P> getPlayerManager();

    @CheckReturnValue
    @NotNull
    public abstract TextUtil getTextUtil();

    @NotNull
    public abstract AbstractCommandRegister<P, ?> commandRegister();

    @NotNull
    public abstract Path getDataFolder();

    @Nullable
    @CheckReturnValue
    public abstract CommandManager<S> getCommandManager();

    @NotNull
    public abstract Logger getSLF4JLogger();

    @NotNull
    public abstract Executor getSyncExecutor();

    @NotNull
    public abstract Executor getAsyncExecutor();

    @NotNull
    public abstract Audience getConsole();

    @NotNull
    public abstract VersionMetadata getVersionMetadata();

    @NotNull
    public abstract MCCCPlayer getPlayer(@NotNull P var1);

    @ApiStatus.Internal
    @ApiStatus.NonExtendable
    @Nullable
    public P objAsPlayer(@NotNull Object obj) {
        try {
            Class<P> playerClass = this.getPlayerClass();
            if (!playerClass.isInstance(obj)) {
                return null;
            }
            return playerClass.cast(obj);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public P asPlayer(@NotNull S sender) {
        return this.objAsPlayer(sender);
    }

    public void registerChatCommands() {
        try {
            GlobalTranslator.translator().addSource((Translator)new KyoriTranslator(NAMESPACE, PREFIX, this, Locale.US));
        }
        catch (Exception e) {
            this.getSLF4JLogger().error("Failed to initialize i18n", (Throwable)e);
        }
        CommandManager<S> manager = this.getCommandManager();
        if (manager == null) {
            throw new IllegalStateException("CommandManager is null");
        }
        EntityMapper<S> mapper = this.commandSenderMapper();
        Command.Builder ccCmd = manager.commandBuilder(NAMESPACE, new String[0]).commandDescription(Description.description((String)"View information about and manage the Crowd Control service"));
        manager.command(ccCmd.literal("status", new String[0]).commandDescription(Description.description((String)"Get the status of the Crowd Control service")).permission(PredicatePermission.of(mapper::isAdmin)).handler(commandContext -> {
            Audience audience = mapper.asAudience(commandContext.sender());
            if (this.crowdControl == null) {
                audience.sendMessage(Plugin.output((Component)Component.translatable((String)"cc.command.crowdcontrol.status.offline")));
                return;
            }
            TextComponent.Builder msg = (TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(PREFIX_COMPONENT)).append((Component)Component.translatable((String)"cc.command.crowdcontrol.status.online"))).appendSpace();
            boolean added = false;
            for (P player : this.getPlayerManager().getAllPlayersFull()) {
                UserToken user;
                CCPlayer ccPlayer = this.optionalCCPlayer(player).orElse(null);
                if (ccPlayer == null || (user = ccPlayer.getUserToken()) == null) continue;
                if (!added) {
                    msg.append((Component)Component.translatable((String)"cc.command.crowdcontrol.status.sources.header"));
                }
                added = true;
                ((TextComponent.Builder)msg.appendNewline()).append((Component)Component.translatable((String)String.format("cc.command.crowdcontrol.status.sources.%s", ccPlayer.getGameSessionId() == null ? "offline" : "live"), (ComponentLike[])new ComponentLike[]{Component.text((String)this.playerMapper().getUsername(player)), Component.text((String)user.getName())}));
            }
            audience.sendMessage((ComponentLike)msg);
        }));
        manager.command(ccCmd.literal("version", new String[0]).commandDescription(Description.description((String)"Get the version of the server's and players' Crowd Control mod")).handler(ctx -> {
            Audience audience = mapper.asAudience(ctx.sender());
            Component message = Plugin.output((Component)Component.translatable((String)"cc.command.crowdcontrol.version.server", (ComponentLike[])new ComponentLike[]{Component.text((String)SemVer.MOD.toString())}));
            audience.sendMessage(message.appendSpace().append((Component)Component.translatable((String)"cc.command.crowdcontrol.version.clients.header")));
            for (P player : this.getPlayerManager().getAllPlayersFull()) {
                Optional<SemVer> version = this.getModVersion(player);
                if (version.isPresent()) {
                    String key = "cc.command.crowdcontrol.version.client." + (version.get().equals(SemVer.MOD) ? "match" : "mismatch");
                    audience.sendMessage((Component)Component.translatable((String)key, (ComponentLike[])new ComponentLike[]{Component.text((String)this.playerMapper().getUsername(player)), Component.text((String)version.get().toString())}));
                    continue;
                }
                audience.sendMessage((Component)Component.translatable((String)"cc.command.crowdcontrol.version.client.unknown", (ComponentLike[])new ComponentLike[]{Component.text((String)this.playerMapper().getUsername(player))}));
            }
        }));
        if (SemVer.MOD.isSnapshot()) {
            manager.command(ccCmd.literal("execute", new String[0]).commandDescription(Description.description((String)"Executes the effect with the given ID")).permission(PredicatePermission.of(mapper::isAdmin)).argument(StringParser.stringComponent((StringParser.StringMode)StringParser.StringMode.SINGLE).name("effect").description(Description.description((String)"ID of the effect to execute")).required().suggestionProvider((context, input) -> CompletableFuture.completedFuture(this.commandRegister().getCommands().stream().filter(command -> command.getEffectName().toLowerCase().contains(input.lastRemainingToken().toLowerCase())).map(command -> Suggestion.suggestion((String)command.getEffectName())).sorted(Comparator.comparing(Suggestion::suggestion)).collect(Collectors.toList())))).handler(commandContext -> {
                Object sender = commandContext.sender();
                Audience audience = mapper.asAudience(sender);
                P player = this.asPlayer(sender);
                if (player == null) {
                    audience.sendMessage(Plugin.output((Component)Component.translatable((String)"cc.command.cast-error", (TextColor)NamedTextColor.RED)));
                    return;
                }
                Command effect = this.commandRegister().getCommandByName((String)commandContext.get("effect"));
                ArrayList players = new ArrayList(Collections.singletonList(player));
                effect.execute(() -> players, new PublicEffectPayload(UUID.randomUUID(), 0L, new CCEffectDescription(effect.getEffectName(), "game", new CCName(this.getTextUtil().asPlain((ComponentLike)effect.getDisplayName())), null, null, null, false, false, false, false, false, false, null, null, null, 10), new CCUserRecord("ccuid-01j7cnrvpbh5aw45pwpe1vqvdw", "lexikiq", ProfileType.TWITCH, "106025167", ""), null, null, false, 1), this.optionalCCPlayer(player).orElseThrow());
            }));
        }
        MinecraftExceptionHandler.create(mapper::asAudience).defaultHandlers().decorator(component -> Plugin.output(component).color((TextColor)NamedTextColor.RED)).registerTo(manager);
    }

    public abstract void loadConfig();

    public boolean globalEffectsUsableFor(@NotNull P player) {
        if (this.isGlobal()) {
            return true;
        }
        Collection<String> hosts = this.getHosts();
        if (hosts.isEmpty()) {
            return false;
        }
        Optional<UUID> optUuid = this.playerMapper().tryGetUniqueId(player);
        if (optUuid.isPresent()) {
            String uuidStr = optUuid.get().toString().replace("-", "");
            if (hosts.stream().anyMatch(host -> host.replace("-", "").equalsIgnoreCase(uuidStr))) {
                return true;
            }
        }
        String name = this.playerMapper().getUsername(player);
        if (hosts.stream().anyMatch(host -> host.equalsIgnoreCase(name))) {
            return true;
        }
        UserToken userToken = optUuid.flatMap(this::optionalCCPlayer).map(CCPlayer::getUserToken).orElse(null);
        if (userToken == null) {
            return false;
        }
        String userId = userToken.getId().replaceFirst("^ccuid-", "");
        if (hosts.stream().anyMatch(host -> host.replaceFirst("^ccuid-", "").equalsIgnoreCase(userId))) {
            return true;
        }
        String ccName = userToken.getName();
        if (hosts.stream().anyMatch(host -> host.equalsIgnoreCase(ccName))) {
            return true;
        }
        String platformId = userToken.getOriginId();
        return hosts.stream().anyMatch(host -> host.equalsIgnoreCase(platformId));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public boolean isHost(@NotNull P player) {
        return this.globalEffectsUsableFor(player);
    }

    public void registerCommand(@NotNull String name, @NotNull Command<P> command) {
        name = name.toLowerCase(Locale.ENGLISH);
        if (this.crowdControl == null) {
            throw new IllegalStateException("CrowdControl is not initialized");
        }
        try {
            if (this.crowdControl.addEffect(name, command)) {
                this.getSLF4JLogger().debug("Registered CC command '{}'", (Object)name);
            } else {
                this.getSLF4JLogger().warn("Command '{}' rejected, duplicate?", (Object)name);
            }
        }
        catch (IllegalArgumentException e) {
            this.getSLF4JLogger().warn("Failed to register command '{}'", (Object)name, (Object)e);
        }
    }

    public void trackEffect(@NotNull UUID requestId, @NotNull TrackedEffect effect) {
        this.trackedEffects.put(requestId, effect);
    }

    @NotNull
    @CheckReturnValue
    public Optional<CrowdControl> optionalCrowdControl() {
        return Optional.ofNullable(this.crowdControl);
    }

    @NotNull
    @CheckReturnValue
    public Optional<CCPlayer> optionalCCPlayer(@NotNull UUID player) {
        return this.optionalCrowdControl().map(cc -> cc.getPlayer(player));
    }

    @NotNull
    @CheckReturnValue
    public Optional<CCPlayer> optionalCCPlayer(@NotNull P player) {
        return this.optionalCCPlayer((P)this.playerMapper().getUniqueId(player));
    }

    public void initCrowdControl() {
        this.loadConfig();
        this.crowdControl = new CrowdControl("Minecraft", "Minecraft", Application.APPLICATION_ID, Application.APPLICATION_SECRET, this.getDataFolder());
        this.commandRegister().register();
        this.getPlayerManager().getAllPlayersFull().forEach(this::onPlayerJoin);
    }

    public CompletableFuture<?> shutdown() {
        if (this.crowdControl != null) {
            this.getPlayerManager().getAllPlayersFull().forEach(this::onPlayerLeave);
            this.crowdControl.close();
            this.crowdControl = null;
        }
        this.scheduledExecutor.shutdown();
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.scheduledExecutor.awaitTermination(3L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @CheckReturnValue
    @NotNull
    public @NotNull CCEffectReport @NotNull [] getConditionalEffectVisibility(IUserRecord user) {
        if (user == null) {
            return new CCEffectReport[0];
        }
        if (this.crowdControl == null) {
            return new CCEffectReport[0];
        }
        List potentialPlayers = this.getPlayerManager().getPotentialPlayers(user).collect(Collectors.toList());
        if (potentialPlayers.isEmpty()) {
            return new CCEffectReport[0];
        }
        SemVer clientVersion = potentialPlayers.stream().map(player -> this.getModVersion(player).orElse(SemVer.ZERO)).max(SemVer::compareTo).orElse(SemVer.ZERO);
        boolean globalVisible = potentialPlayers.stream().anyMatch(this::globalEffectsUsableFor);
        this.getSLF4JLogger().debug("Updating conditional effects: clientVersion={}, globalVisible={}", (Object)clientVersion, (Object)globalVisible);
        HashMap<ReportStatus, List> effects = new HashMap<ReportStatus, List>();
        List<Command<P>> registeredEffects = this.commandRegister().getCommands();
        List registeredEffectIds = registeredEffects.stream().map(Command::getEffectName).map(name -> name.toLowerCase(Locale.ENGLISH)).collect(Collectors.toList());
        List unknownEffects = OptionalUtil.stream(Optional.ofNullable(this.crowdControl.getGamePack()).map(pack -> pack.getEffects().getGame())).flatMap(map -> map.keySet().stream()).filter(id -> !registeredEffectIds.contains(id)).collect(Collectors.toList());
        if (!unknownEffects.isEmpty()) {
            effects.put(ReportStatus.MENU_HIDDEN, unknownEffects);
        }
        for (Command command : this.commandRegister().getCommands()) {
            TriState selectable;
            TriState visibility;
            String id2 = command.getEffectName().toLowerCase(Locale.ENGLISH);
            try {
                visibility = command.isVisible(user, potentialPlayers);
                if (visibility != TriState.FALSE) {
                    Set<ExtraFeature> extraFeatures = command.requiredExtraFeatures();
                    if (!extraFeatures.isEmpty()) {
                        boolean available = potentialPlayers.stream().anyMatch(player -> extraFeatures.stream().allMatch(feature -> this.isFeatureAvailable((ExtraFeature)((Object)((Object)((Object)feature))), (P)player)));
                        visibility = TriState.fromBoolean(available);
                    } else {
                        SemVer minVersion = command.getMinimumModVersion();
                        if (minVersion.isAtLeast(SemVer.ZERO)) {
                            visibility = TriState.fromBoolean(clientVersion.isAtLeast(minVersion));
                        } else if (command.isGlobal()) {
                            visibility = TriState.fromBoolean(globalVisible);
                        }
                    }
                }
            }
            catch (Exception e) {
                this.getSLF4JLogger().error("Hiding faulty effect {}", (Object)id2, (Object)e);
                visibility = TriState.FALSE;
            }
            if (visibility != TriState.UNKNOWN) {
                effects.computeIfAbsent(visibility == TriState.TRUE ? ReportStatus.MENU_VISIBLE : ReportStatus.MENU_HIDDEN, k -> new ArrayList()).add(id2);
            }
            try {
                selectable = command.isSelectable(user, potentialPlayers);
            }
            catch (Exception e) {
                this.getSLF4JLogger().error("Disabling faulty effect {}", (Object)id2, (Object)e);
                selectable = TriState.FALSE;
            }
            if (selectable == TriState.UNKNOWN || visibility == TriState.FALSE) continue;
            effects.computeIfAbsent(selectable == TriState.TRUE ? ReportStatus.MENU_AVAILABLE : ReportStatus.MENU_UNAVAILABLE, k -> new ArrayList()).add(id2);
        }
        CCEffectReport[] reports = new CCEffectReport[effects.size()];
        boolean bl = false;
        for (Map.Entry entry : effects.entrySet()) {
            reports[++var10_12] = new CCEffectReport(IdentifierType.EFFECT, (ReportStatus)((Object)entry.getKey()), (List)entry.getValue());
        }
        return reports;
    }

    public void updateConditionalEffectVisibility(CCPlayer ccPlayer) {
        if (ccPlayer == null) {
            return;
        }
        if (ccPlayer.getGameSessionId() == null) {
            return;
        }
        if (ccPlayer.getUserToken() == null) {
            return;
        }
        CCEffectReport[] reports = this.getConditionalEffectVisibility(ccPlayer.getUserToken());
        if (reports.length == 0) {
            return;
        }
        ccPlayer.sendReport(reports);
    }

    public void updateConditionalEffectVisibility(P player) {
        this.updateConditionalEffectVisibility((CCPlayer)this.optionalCCPlayer(player).orElse(null));
    }

    public void updateConditionalEffectVisibility(UUID player) {
        this.updateConditionalEffectVisibility((CCPlayer)this.optionalCCPlayer((P)player).orElse(null));
    }

    public void updateConditionalEffectVisibility() {
        if (this.crowdControl == null) {
            return;
        }
        this.crowdControl.getPlayers().forEach(this::updateConditionalEffectVisibility);
    }

    public void onPlayerJoin(P joiningPlayer) {
        CrowdControl cc = this.getCrowdControl();
        if (cc == null) {
            return;
        }
        PlayerEntityMapper mapper = this.playerMapper();
        UUID uuid = mapper.tryGetUniqueId(joiningPlayer).orElse(null);
        if (uuid == null) {
            this.getSLF4JLogger().warn("Joining player {} has no UUID", (Object)mapper.getUsername(joiningPlayer));
            return;
        }
        mapper.asAudience(joiningPlayer).sendMessage(JOIN_MESSAGE);
        if (!this.playerMapper().hasPermission(joiningPlayer, USE_PERMISSION)) {
            return;
        }
        CCPlayer ccPlayer = cc.addPlayer(uuid);
        ccPlayer.getEventManager().registerEventConsumer(CCEventType.GENERATED_AUTH_CODE, payload -> {
            String url = ccPlayer.getAuthUrl();
            if (url == null) {
                return;
            }
            Optional optPlayer = mapper.getPlayer(uuid);
            if (optPlayer.isEmpty()) {
                return;
            }
            Object player = optPlayer.get();
            Audience audience = mapper.asAudience(player);
            if (ccPlayer.getUserToken() == null) {
                audience.sendMessage((Component)Component.translatable((String)"cc.join.link.text.1", (TextColor)TextColor.color((int)15848700)));
                audience.sendMessage((Component)Component.translatable((String)"cc.join.link.text.2", (TextColor)TextColor.color((int)15257330)).arguments(new ComponentLike[]{Component.keybind((String)"key.chat")}));
                audience.sendMessage(((TranslatableComponent)Component.translatable((String)"cc.join.link.text.3", (TextColor)TextColor.color((int)14796779)).clickEvent(ClickEvent.copyToClipboard((String)ccPlayer.getAuthUrl()))).hoverEvent((HoverEventSource)Component.translatable((String)"cc.join.link.text.3.hover")));
                audience.sendMessage((Component)Component.translatable((String)"cc.join.link.text.4", (TextColor)TextColor.color((int)14270947), (TextDecoration[])new TextDecoration[]{TextDecoration.ITALIC}));
                audience.sendMessage((Component)Component.translatable((String)"cc.join.link.text.5", (TextColor)TextColor.color((int)13810395), (TextDecoration[])new TextDecoration[]{TextDecoration.ITALIC}));
                audience.sendMessage((Component)Component.translatable((String)"cc.join.link.text.6", (TextColor)TextColor.color((int)13350100)));
                audience.sendMessage((Component)Component.translatable((String)"cc.join.link.text.7", (TextColor)TextColor.color((int)12824012), (TextDecoration[])new TextDecoration[]{TextDecoration.ITALIC}));
            }
        });
        ccPlayer.getEventManager().registerEventRunnable(CCEventType.AUTHENTICATED, () -> {
            if (ccPlayer.getGameSessionId() != null) {
                return;
            }
            if (ccPlayer.getUserToken() == null) {
                return;
            }
            this.playerMapper().getPlayer(ccPlayer.getUuid()).ifPresent(p -> this.playerMapper().asAudience(p).sendMessage(PREFIX_COMPONENT.append((Component)Component.translatable((String)"cc.join.authenticated").args(new ComponentLike[]{Component.text((String)ccPlayer.getUserToken().getName())}))));
            ccPlayer.startSession(this.getConditionalEffectVisibility(ccPlayer.getUserToken()));
        });
        ccPlayer.getEventManager().registerEventRunnable(CCEventType.SESSION_STARTED, () -> {
            UserToken user = ccPlayer.getUserToken();
            if (user == null) {
                return;
            }
            this.playerMapper().getPlayer(ccPlayer.getUuid()).ifPresent(p -> this.playerMapper().asAudience(p).sendMessage(PREFIX_COMPONENT.append((Component)Component.translatable((String)"cc.join.session")).clickEvent(ClickEvent.copyToClipboard((String)String.format("https://interact.crowdcontrol.live/#/%s/%s", user.getProfile().getValue(), user.getOriginId())))));
        });
        ccPlayer.getEventManager().registerEventConsumer(CCEventType.EFFECT_REQUEST, request -> this.getSLF4JLogger().debug("New request {}", (Object)request.getRequestId()));
        ccPlayer.getEventManager().registerEventConsumer(CCEventType.EFFECT_RESPONSE, response -> {
            Command<P> command;
            UUID requestId = response.getRequestId();
            this.getSLF4JLogger().debug("Effect response {}", (Object)requestId);
            ResponseStatus status = response.getStatus();
            TrackedEffect effect = this.trackedEffects.get(requestId);
            if (effect == null) {
                return;
            }
            try {
                command = this.commandRegister().getCommandByName(effect.getRequest().getEffect().getEffectId());
            }
            catch (IllegalArgumentException e) {
                this.trackedEffects.remove(requestId);
                return;
            }
            switch (status) {
                case SUCCESS: {
                    ArrayList audiences = new ArrayList(3);
                    CollectionUtil.initTo(audiences, this::getConsole);
                    if (this.announce) {
                        CollectionUtil.initTo(audiences, effect::getAudience);
                        CollectionUtil.initTo(audiences, () -> this.playerMapper().asAudience(this.getPlayerManager().getSpectators().collect(Collectors.toList())));
                    }
                    try {
                        Audience.audience(audiences).sendMessage((Component)Component.translatable((String)"cc.effect.used", (ComponentLike[])new ComponentLike[]{this.getViewerComponent(effect.getRequest(), true).color(USER_COLOR), command.getProcessedDisplayName(effect.getRequest()).colorIfAbsent(CMD_COLOR)}));
                    }
                    catch (Exception e) {
                        LoggerFactory.getLogger((String)"CrowdControl/Command").warn("Failed to announce effect", (Throwable)e);
                    }
                }
                case FAIL_TEMPORARY: 
                case FAIL_PERMANENT: 
                case TIMED_END: 
                case UNKNOWN: {
                    this.trackedEffects.remove(requestId);
                }
            }
        });
    }

    public void onPlayerLeave(P player) {
        PlayerEntityMapper<P> mapper = this.playerMapper();
        UUID uuid = mapper.tryGetUniqueId(player).orElse(null);
        if (uuid == null) {
            this.getSLF4JLogger().warn("Departing player {} has no UUID", (Object)mapper.getUsername(player));
            return;
        }
        this.clientVersions.remove(uuid);
        this.extraFeatures.remove(uuid);
        if (this.crowdControl == null) {
            return;
        }
        this.crowdControl.removePlayer(uuid);
    }

    @Nullable
    public Component getViewerComponentOrNull(@NotNull PublicEffectPayload request, boolean chat) {
        if (request.isAnonymous()) {
            return null;
        }
        CCUserRecord viewer = request.getRequester();
        if (viewer == null) {
            return null;
        }
        String name = viewer.getName();
        if (name.isEmpty()) {
            return null;
        }
        if (!chat && this.hideNames.isHideOther() || chat && this.hideNames.isHideChat()) {
            return null;
        }
        return Component.text((String)name);
    }

    @NotNull
    public Component getViewerComponent(@NotNull PublicEffectPayload request, boolean chat) {
        return ExceptionUtil.validateNotNullElse(this.getViewerComponentOrNull(request, chat), VIEWER_NAME);
    }

    @NotNull
    public Optional<SemVer> getModVersion(@NotNull P player) {
        return Optional.ofNullable(this.clientVersions.get(this.playerMapper().getUniqueId(player)));
    }

    @NotNull
    public Set<ExtraFeature> getExtraFeatures(@NotNull P player) {
        return this.extraFeatures.getOrDefault(this.playerMapper().getUniqueId(player), Collections.emptySet());
    }

    public boolean isFeatureAvailable(@NotNull ExtraFeature feature, @NotNull P player) {
        return this.getExtraFeatures(player).contains((Object)feature);
    }

    @ApiStatus.Internal
    @Nullable
    public Path getPath(@NotNull String asset) {
        try {
            return Paths.get(this.getClass().getClassLoader().getResource(asset).toURI());
        }
        catch (Exception ignored) {
            return null;
        }
    }

    @ApiStatus.Internal
    @Nullable
    public InputStream getInputStream(@NotNull String asset) {
        return this.getClass().getClassLoader().getResourceAsStream(asset);
    }

    public boolean isPaused() {
        return false;
    }
}

