/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.common.command;

import dev.qixils.crowdcontrol.TrackedEffect;
import dev.qixils.crowdcontrol.TriState;
import dev.qixils.crowdcontrol.common.EventListener;
import dev.qixils.crowdcontrol.common.Global;
import dev.qixils.crowdcontrol.common.Plugin;
import dev.qixils.crowdcontrol.common.command.QuantityStyle;
import dev.qixils.crowdcontrol.common.packets.util.ExtraFeature;
import dev.qixils.crowdcontrol.common.util.CCResponseException;
import dev.qixils.crowdcontrol.common.util.DynamicForwardingAudience;
import dev.qixils.crowdcontrol.common.util.SemVer;
import dev.qixils.relocated.annotations.ApiStatus;
import dev.qixils.relocated.annotations.CheckReturnValue;
import dev.qixils.relocated.annotations.NotNull;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import live.crowdcontrol.cc4j.CCEffect;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.CrowdControl;
import live.crowdcontrol.cc4j.IUserRecord;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.TextColor;

public interface Command<P>
extends CCEffect {
    @NotNull
    @CheckReturnValue
    public Plugin<P, ?> getPlugin();

    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull P>> var1, @NotNull PublicEffectPayload var2, @NotNull CCPlayer var3);

    default public boolean isEventListener() {
        return this.getClass().isAnnotationPresent(EventListener.class);
    }

    @NotNull
    @CheckReturnValue
    public String getEffectName();

    @NotNull
    @CheckReturnValue
    default public SemVer getMinimumModVersion() {
        return SemVer.ZERO;
    }

    @NotNull
    default public Set<ExtraFeature> requiredExtraFeatures() {
        return EnumSet.noneOf(ExtraFeature.class);
    }

    @NotNull
    @CheckReturnValue
    default public TranslatableComponent getDefaultDisplayName() {
        return Component.translatable((String)("cc.effect." + this.getEffectName() + ".name"));
    }

    @NotNull
    @CheckReturnValue
    default public Component getDisplayName() {
        return this.getDefaultDisplayName();
    }

    @NotNull
    @CheckReturnValue
    default public Component getProcessedDisplayName(@NotNull PublicEffectPayload request) {
        Component displayName = this.getDisplayName();
        try {
            if (request.getQuantity() > 1) {
                displayName = this.getQuantityName(displayName, request);
            }
            if (request.getEffect().getDuration() > 0) {
                displayName = this.getDurationName(displayName, request);
            }
        }
        catch (Exception e) {
            this.getPlugin().getSLF4JLogger().warn("Failed to get display name", (Throwable)e);
        }
        return displayName;
    }

    @ApiStatus.Internal
    @ApiStatus.OverrideOnly
    default public Component getQuantityName(@NotNull Component displayName, @NotNull PublicEffectPayload request) {
        CharSequence[] keyParts;
        if (!(displayName instanceof TranslatableComponent)) {
            return displayName;
        }
        QuantityStyle style = this.getQuantityStyle();
        if (style == QuantityStyle.NONE) {
            return displayName;
        }
        TranslatableComponent translatable = (TranslatableComponent)displayName;
        ArrayList<TextComponent> args = new ArrayList<TextComponent>(translatable.args());
        TextComponent quantity = Component.text((int)request.getQuantity());
        if (style == QuantityStyle.APPEND || style == QuantityStyle.APPEND_X) {
            args.add(quantity);
        } else if (style == QuantityStyle.PREPEND || style == QuantityStyle.PREPEND_X) {
            args.add(0, quantity);
        }
        translatable = translatable.args(args);
        if ((style == QuantityStyle.APPEND_X || style == QuantityStyle.PREPEND_X) && request.getQuantity() > 1 && (keyParts = translatable.key().split("\\.")).length == 4 && keyParts[0].equals("cc") && keyParts[1].equals("effect") && keyParts[3].equals("name")) {
            keyParts[2] = keyParts[2] + "_x";
            String key = String.join((CharSequence)".", keyParts);
            translatable = translatable.key(key);
        }
        return translatable;
    }

    @ApiStatus.Internal
    @ApiStatus.OverrideOnly
    default public Component getDurationName(@NotNull Component displayName, @NotNull PublicEffectPayload request) {
        Duration duration = Duration.ofSeconds(request.getEffect().getDuration());
        return displayName.append((Component)Component.text((String)(" (" + duration.getSeconds() + "s)"), (TextColor)Plugin.DIM_CMD_COLOR));
    }

    @NotNull
    @CheckReturnValue
    default public QuantityStyle getQuantityStyle() {
        return QuantityStyle.NONE;
    }

    @Override
    default public void onTrigger(@NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        Plugin plugin = this.getPlugin();
        plugin.getSLF4JLogger().debug("Executing {} from {}", (Object)this.getDisplayName(), (Object)request);
        Function<Boolean, List> playerSupplier = _force -> {
            Set<ExtraFeature> extraFeatures;
            boolean force = _force;
            if (this.isExclusive() && this.isArrayActive(ccPlayer) && !force) {
                throw new CCResponseException(new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Conflicting effects were already active"));
            }
            this.getPlugin().getSLF4JLogger().debug("Plugin is paused: {}; force: {}", (Object)this.getPlugin().isPaused(), (Object)force);
            if (this.getPlugin().isPaused() && !force) {
                throw new CCResponseException(new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Cannot run effects whilst game is paused"));
            }
            Stream<Object> playerStream = plugin.getPlayerManager().getPlayers(request);
            SemVer minVersion = this.getMinimumModVersion();
            if (minVersion.isGreaterThan(SemVer.ZERO)) {
                playerStream = playerStream.filter(player -> plugin.getModVersion(player).orElse(SemVer.ZERO).isAtLeast(minVersion));
            }
            if (!(extraFeatures = this.requiredExtraFeatures()).isEmpty()) {
                playerStream = playerStream.filter(player -> extraFeatures.stream().allMatch(feature -> plugin.isFeatureAvailable((ExtraFeature)((Object)((Object)((Object)feature))), player)));
            }
            List playerList = playerStream.collect(Collectors.toList());
            if (this.isGlobal()) {
                if (playerList.stream().noneMatch(plugin::globalEffectsUsableFor) && !force) {
                    throw new CCResponseException(new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_PERMANENT, "Global effects cannot be used on the targeted streamer"));
                }
            }
            if (playerList.isEmpty() && !force) {
                throw new CCResponseException(new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "No available players online"));
            }
            Collections.shuffle(playerList);
            return playerList;
        };
        plugin.trackEffect(request.getRequestId(), new TrackedEffect((Audience)new DynamicForwardingAudience(() -> plugin.playerMapper().asAudience((Collection)playerSupplier.apply(true))), request, ccPlayer));
        try {
            this.execute(() -> (List)playerSupplier.apply(false), request, ccPlayer);
        }
        catch (CCResponseException e) {
            ccPlayer.sendResponse(e.getResponse());
        }
    }

    default public void sync(@NotNull Runnable runnable) {
        this.getPlugin().getSyncExecutor().execute(runnable);
    }

    default public void async(@NotNull Runnable runnable) {
        this.getPlugin().getAsyncExecutor().execute(runnable);
    }

    default public boolean isGlobal() {
        return this.getClass().isAnnotationPresent(Global.class);
    }

    default public TriState isSelectable(@NotNull IUserRecord user, @NotNull List<P> potentialPlayers) {
        return TriState.UNKNOWN;
    }

    default public TriState isVisible(@NotNull IUserRecord user, @NotNull List<P> potentialPlayers) {
        return TriState.UNKNOWN;
    }

    default public boolean isExclusive() {
        return true;
    }

    @ApiStatus.NonExtendable
    default public boolean isActive(@NotNull CCPlayer player, String ... effectIDs) {
        CrowdControl cc = this.getPlugin().getCrowdControl();
        if (cc == null) {
            return false;
        }
        UUID uuid = player.getUuid();
        return Arrays.stream(effectIDs).flatMap(effectID -> Stream.concat(Stream.of(effectID), this.getPlugin().commandRegister().getEffectsByGroup((String)effectID).stream())).anyMatch(effectID -> cc.isPlayerEffectActive((String)effectID, uuid));
    }

    default public boolean isArrayActive(@NotNull CCPlayer player) {
        return this.isActive(player, this.getEffectArray());
    }

    default public List<String> getEffectGroups() {
        return Collections.emptyList();
    }

    default public String[] getEffectArray() {
        ArrayList<String> list = new ArrayList<String>(this.getEffectGroups());
        list.add(this.getEffectName().toLowerCase(Locale.US));
        return list.toArray(new String[0]);
    }
}

