/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.common.command.impl;

import dev.qixils.crowdcontrol.common.Plugin;
import dev.qixils.crowdcontrol.common.command.Command;
import dev.qixils.crowdcontrol.common.mc.MCCCPlayer;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.relocated.annotations.NotNull;
import java.util.List;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;

public class HalfHealthCommand<P>
implements Command<P> {
    private final String effectName = "half_health";
    private final Plugin<P, ?> plugin;

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull P>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(() -> {
            List players = (List)playerSupplier.get();
            boolean success = false;
            for (Object rawPlayer : players) {
                MCCCPlayer player = this.plugin.getPlayer(rawPlayer);
                double health = player.health();
                if (!(health > 6.0)) continue;
                this.sync(() -> player.damage(health / 2.0));
                success = true;
            }
            return success ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Health is already minimum");
        }));
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }

    @Override
    public Plugin<P, ?> getPlugin() {
        return this.plugin;
    }

    public HalfHealthCommand(Plugin<P, ?> plugin) {
        this.plugin = plugin;
    }
}

