/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.common.command.impl;

import dev.qixils.crowdcontrol.common.Plugin;
import dev.qixils.crowdcontrol.common.command.Command;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.relocated.annotations.NotNull;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.CCTimedEffect;
import live.crowdcontrol.cc4j.websocket.data.CCTimedEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;

public class HealthModifierCommand<P>
implements Command<P>,
CCTimedEffect {
    @NotNull
    public static final Map<UUID, Modifier> ACTIVE_MODIFIERS = new HashMap<UUID, Modifier>();
    @NotNull
    private final Duration defaultDuration = Duration.ofSeconds(15L);
    @NotNull
    private final String effectGroup = "health_modifiers";
    @NotNull
    private final List<String> effectGroups = Collections.singletonList("health_modifiers");
    @NotNull
    private final Modifier type;
    @NotNull
    private final Plugin<P, ?> plugin;
    @NotNull
    private final String effectName;
    @NotNull
    private final Map<UUID, Set<UUID>> playerMap = new HashMap<UUID, Set<UUID>>();

    public HealthModifierCommand(@NotNull Plugin<P, ?> plugin, @NotNull Modifier type) {
        this.plugin = plugin;
        this.type = type;
        this.effectName = type.name().toLowerCase(Locale.US);
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull P>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(() -> {
            List players = (List)playerSupplier.get();
            this.playerMap.put(request.getRequestId(), players.stream().map(p -> this.plugin.playerMapper().getUniqueId(p)).collect(Collectors.toSet()));
            for (Object player : players) {
                ACTIVE_MODIFIERS.put(this.plugin.playerMapper().getUniqueId(player), this.type);
            }
            return new CCTimedEffectResponse(request.getRequestId(), ResponseStatus.TIMED_BEGIN, (long)request.getEffect().getDuration() * 1000L);
        }));
    }

    @Override
    public void onEnd(@NotNull PublicEffectPayload request, @NotNull CCPlayer source) {
        Set<UUID> players = this.playerMap.remove(request.getRequestId());
        if (players == null) {
            return;
        }
        for (UUID player : players) {
            ACTIVE_MODIFIERS.remove(player, (Object)this.type);
        }
    }

    @NotNull
    public Duration getDefaultDuration() {
        return this.defaultDuration;
    }

    @NotNull
    public String getEffectGroup() {
        return this.effectGroup;
    }

    @Override
    @NotNull
    public List<String> getEffectGroups() {
        return this.effectGroups;
    }

    @NotNull
    public Modifier getType() {
        return this.type;
    }

    @Override
    @NotNull
    public Plugin<P, ?> getPlugin() {
        return this.plugin;
    }

    @Override
    @NotNull
    public String getEffectName() {
        return this.effectName;
    }

    @NotNull
    public Map<UUID, Set<UUID>> getPlayerMap() {
        return this.playerMap;
    }

    public static enum Modifier {
        INVINCIBLE,
        OHKO;

    }
}

