/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.common.command.impl.health;

import dev.qixils.crowdcontrol.common.Plugin;
import dev.qixils.crowdcontrol.common.command.Command;
import dev.qixils.crowdcontrol.common.mc.CCEntity;
import dev.qixils.crowdcontrol.common.mc.MCCCPlayer;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.relocated.annotations.NotNull;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;

public class KillCommand<P>
implements Command<P> {
    @NotNull
    private final String effectName = "kill";
    @NotNull
    private final Plugin<P, ?> plugin;

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull P>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(() -> {
            List players = (List)playerSupplier.get();
            if (this.isActive(ccPlayer, "health_modifiers", "freeze")) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Cannot kill players under the effects of health or location modifiers");
            }
            Stream<MCCCPlayer> streamers = players.stream().map(this.plugin::getPlayer);
            this.sync(() -> streamers.forEach(CCEntity::kill));
            return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS);
        }));
    }

    public KillCommand(@NotNull Plugin<P, ?> plugin) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public String getEffectName() {
        return this.effectName;
    }

    @Override
    @NotNull
    public Plugin<P, ?> getPlugin() {
        return this.plugin;
    }
}

