/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.common.util;

import dev.qixils.relocated.annotations.Contract;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;

public final class KeyedTag
implements Iterable<Key> {
    private final Set<Key> keyedSet;

    public KeyedTag() {
        this.keyedSet = Collections.emptySet();
    }

    public KeyedTag(Key ... items) {
        this.keyedSet = Collections.unmodifiableSet(new HashSet<Key>(Arrays.asList(items)));
    }

    public KeyedTag(Keyed ... items) {
        HashSet<Key> keyedSet = new HashSet<Key>(items.length);
        for (Keyed item : items) {
            keyedSet.add(item.key());
        }
        this.keyedSet = Collections.unmodifiableSet(keyedSet);
    }

    public KeyedTag(@NotNull @NotNull Collection<@NotNull Keyed> items) {
        HashSet<Key> keyedSet = new HashSet<Key>(items.size());
        for (Keyed item : items) {
            keyedSet.add(item.key());
        }
        this.keyedSet = Collections.unmodifiableSet(keyedSet);
    }

    public KeyedTag(@NotNull @NotNull Collection<@NotNull Key> items1, @Nullable Collection<@NotNull Key> items2) {
        int itemCount = items1.size();
        if (items2 != null) {
            itemCount += items2.size();
        }
        HashSet<Key> keyedSet = new HashSet<Key>(itemCount);
        keyedSet.addAll(items1);
        if (items2 != null) {
            keyedSet.addAll(items2);
        }
        this.keyedSet = Collections.unmodifiableSet(keyedSet);
    }

    public KeyedTag(KeyedTag tag) {
        this.keyedSet = Collections.unmodifiableSet(new HashSet<Key>(tag.getKeys()));
    }

    @NotNull
    public Set<Key> getKeys() {
        return this.keyedSet;
    }

    @Override
    @NotNull
    public Iterator<Key> iterator() {
        return this.getKeys().iterator();
    }

    @Override
    @NotNull
    public Spliterator<Key> spliterator() {
        return this.getKeys().spliterator();
    }

    public boolean contains(@NotNull Keyed item) {
        return this.keyedSet.contains(item.key());
    }

    @Contract(value="null -> false; !null -> _")
    public boolean contains(@Nullable Key item) {
        return this.keyedSet.contains(item);
    }

    @Contract(value="null -> false; !null -> _")
    public boolean contains(@Nullable String item) {
        for (Key key : this.keyedSet) {
            if (!key.asString().equals(item)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public KeyedTag and(Key ... items) {
        return new KeyedTag(this.keyedSet, Arrays.asList(items));
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public KeyedTag and(Keyed ... items) {
        HashSet<Key> newTag = new HashSet<Key>(items.length);
        for (Keyed item : items) {
            newTag.add(item.key());
        }
        return new KeyedTag(this.keyedSet, newTag);
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public KeyedTag and(@NotNull @NotNull Collection<@NotNull Keyed> other) {
        return new KeyedTag(this.keyedSet, other.stream().map(Keyed::key).collect(Collectors.toSet()));
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public KeyedTag and(@NotNull KeyedTag other) {
        return new KeyedTag(this.keyedSet, other.getKeys());
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public KeyedTag except(Key ... keys) {
        return this.except(Arrays.asList(keys));
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public KeyedTag except(@NotNull Collection<Key> keys) {
        HashSet<Key> newSet = new HashSet<Key>(this.keyedSet.size());
        for (Key key : this.keyedSet) {
            if (keys.contains(key)) continue;
            newSet.add(key);
        }
        return new KeyedTag(newSet, null);
    }
}

