/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.common.util;

import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.io.InputStream;
import java.util.Objects;
import java.util.Scanner;

public final class SemVer
implements Comparable<SemVer> {
    @NotNull
    public static final SemVer MOD;
    @NotNull
    public static final String MOD_STRING;
    @NotNull
    public static final SemVer ZERO;
    @NotNull
    public static final SemVer MIN;
    private final int major;
    private final int minor;
    private final int patch;
    private final boolean isSnapshot;
    private final boolean isRelease;

    public SemVer(int major, int minor, int patch, boolean isSnapshot, boolean isRelease) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.isSnapshot = isSnapshot;
        this.isRelease = isRelease;
    }

    public SemVer(int major, int minor, int patch, boolean isSnapshot) {
        this(major, minor, patch, isSnapshot, !isSnapshot);
    }

    public SemVer(int major, int minor, int patch) {
        this(major, minor, patch, false, true);
    }

    public SemVer(int major, int minor) {
        this(major, minor, 0, false, true);
    }

    public SemVer(@NotNull String version) {
        String[] parts = version.split("\\.", 3);
        if (parts.length < 1) {
            throw new IllegalArgumentException("Invalid version string: " + version);
        }
        try {
            this.major = Integer.parseInt(parts[0]);
            int n = this.minor = parts.length > 1 ? Integer.parseInt(parts[1]) : 0;
            if (parts.length > 2) {
                int dashIndex = parts[2].indexOf(45);
                if (dashIndex == -1) {
                    this.patch = Integer.parseInt(parts[2]);
                    this.isSnapshot = false;
                    this.isRelease = true;
                } else {
                    this.patch = Integer.parseInt(parts[2].substring(0, dashIndex));
                    this.isSnapshot = parts[2].substring(dashIndex + 1).endsWith("SNAPSHOT");
                    this.isRelease = false;
                }
            } else {
                this.patch = 0;
                this.isSnapshot = false;
                this.isRelease = true;
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid version string: " + version);
        }
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int patch() {
        return this.patch;
    }

    public boolean isSnapshot() {
        return this.isSnapshot;
    }

    public boolean isRelease() {
        return this.isRelease;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append(this.major).append('.').append(this.minor).append('.').append(this.patch);
        if (this.isSnapshot) {
            builder.append("-SNAPSHOT");
        }
        return builder.toString();
    }

    public boolean isAtLeast(@NotNull SemVer other) {
        return this.compareTo(other) >= 0;
    }

    public boolean isAtMost(@NotNull SemVer other) {
        return this.compareTo(other) <= 0;
    }

    public boolean isGreaterThan(@NotNull SemVer other) {
        return this.compareTo(other) > 0;
    }

    public boolean isLessThan(@NotNull SemVer other) {
        return this.compareTo(other) < 0;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SemVer other = (SemVer)o;
        return this.major == other.major && this.minor == other.minor && this.patch == other.patch;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch);
    }

    @Override
    public int compareTo(@NotNull SemVer o) {
        if (this.major != o.major) {
            return this.major - o.major;
        }
        if (this.minor != o.minor) {
            return this.minor - o.minor;
        }
        return this.patch - o.patch;
    }

    static {
        ZERO = new SemVer(0, 0, 0);
        MIN = new SemVer(0, 0, 1);
        InputStream inputStream = SemVer.class.getClassLoader().getResourceAsStream("mccc-version.txt");
        if (inputStream == null) {
            throw new IllegalStateException("Could not load version from resources");
        }
        MOD_STRING = new Scanner(inputStream).next();
        MOD = new SemVer(MOD_STRING);
    }
}

