/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.TriState;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.commands.KeepInventoryCommand;
import dev.qixils.crowdcontrol.plugin.fabric.utils.InventoryUtil;
import dev.qixils.relocated.annotations.NotNull;
import java.util.List;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.IUserRecord;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;

public class ClearInventoryCommand
extends ModdedCommand {
    private final String effectName = "clear_inventory";

    public ClearInventoryCommand(ModdedCrowdControlPlugin plugin) {
        super(plugin);
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(() -> {
            boolean success = false;
            for (ServerPlayer player : (List)playerSupplier.get()) {
                if (KeepInventoryCommand.isKeepingInventory((Entity)player)) continue;
                Inventory inv = player.getInventory();
                boolean hasItems = false;
                for (ItemStack item : InventoryUtil.viewAllItems(inv)) {
                    if (item.isEmpty()) continue;
                    hasItems = true;
                    break;
                }
                if (!hasItems) continue;
                success = true;
                this.sync(() -> ((Inventory)inv).clearContent());
            }
            return success ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "All inventories are already empty or protected");
        }));
    }

    @Override
    public TriState isVisible(@NotNull IUserRecord user, @NotNull List<ServerPlayer> potentialPlayers) {
        return potentialPlayers.stream().anyMatch(player -> player.serverLevel().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY)) ? TriState.FALSE : TriState.TRUE;
    }

    @Override
    public TriState isSelectable(@NotNull IUserRecord user, @NotNull List<ServerPlayer> potentialPlayers) {
        if (this.plugin.isGlobal()) {
            return KeepInventoryCommand.globalKeepInventory ? TriState.FALSE : TriState.TRUE;
        }
        TriState keepingInventory = potentialPlayers.stream().map(player -> TriState.fromBoolean(KeepInventoryCommand.isKeepingInventory(player.getUUID()))).reduce((prev, next) -> {
            if (prev != next) {
                return TriState.UNKNOWN;
            }
            return prev;
        }).orElse(TriState.UNKNOWN);
        if (keepingInventory == TriState.TRUE) {
            return TriState.FALSE;
        }
        return TriState.TRUE;
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }
}

