/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.utils.Location;
import dev.qixils.relocated.annotations.NotNull;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Blocks;

public class DigCommand
extends ModdedCommand {
    private final String effectName = "dig";

    public DigCommand(ModdedCrowdControlPlugin plugin) {
        super(plugin);
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(() -> {
            HashSet<Location> locations = new HashSet<Location>();
            int depth = CommandConstants.getDigDepth();
            for (ServerPlayer player : (List)playerSupplier.get()) {
                Location playerLocation = new Location((Entity)player);
                for (double x = -0.5; x <= 0.5; x += 1.0) {
                    for (int y = depth; y <= 0; ++y) {
                        for (double z = -0.5; z <= 0.5; z += 1.0) {
                            Location block = playerLocation.add(x, y, z);
                            if (block.block().isAir()) continue;
                            locations.add(block);
                        }
                    }
                }
            }
            if (locations.isEmpty()) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Streamer(s) not standing on any blocks");
            }
            this.sync(() -> {
                for (Location location : locations) {
                    location.block(Blocks.AIR.defaultBlockState());
                }
            });
            return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS);
        }));
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }
}

