/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.TriState;
import dev.qixils.crowdcontrol.plugin.fabric.FeatureElementCommand;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.util.List;
import java.util.stream.StreamSupport;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.IUserRecord;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.flag.FeatureFlagSet;

public interface EntityCommand<E extends Entity>
extends FeatureElementCommand {
    @NotNull
    public EntityType<? extends E> getEntityType();

    @NotNull
    default public FeatureFlagSet requiredFeatures() {
        return this.getEntityType().requiredFeatures();
    }

    default public boolean isMonster() {
        return this.getEntityType().getCategory() == MobCategory.MONSTER;
    }

    default public boolean levelIsPeaceful(@NotNull ServerLevel level) {
        return level.getDifficulty() == Difficulty.PEACEFUL;
    }

    default public boolean serverIsPeaceful() {
        return StreamSupport.stream(this.getPlugin().server().getAllLevels().spliterator(), false).allMatch(this::levelIsPeaceful);
    }

    @Override
    default public TriState isSelectable(@NotNull IUserRecord user, @NotNull List<ServerPlayer> potentialPlayers) {
        if (!this.isMonster()) {
            return TriState.UNKNOWN;
        }
        if (!this.serverIsPeaceful()) {
            return TriState.TRUE;
        }
        return TriState.FALSE;
    }

    @Nullable
    default public CCEffectResponse tryExecute(@NotNull @NotNull List<@NotNull ServerPlayer> players, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        CCInstantEffectResponse error = null;
        for (ServerPlayer player : players) {
            ServerLevel level = player.serverLevel();
            if (this.isMonster() && this.levelIsPeaceful(level)) {
                error = new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Hostile mobs cannot be spawned while on Peaceful difficulty");
                continue;
            }
            if (this.getEntityType() == EntityType.ENDER_DRAGON && level.getDragonFight() != null) {
                error = new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Ender Dragons are very sensitive cannot be spawned in or removed from The End, sorry!");
                continue;
            }
            if (!this.isEnabled(player.serverLevel().enabledFeatures())) {
                error = new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Mob is not available in this version of Minecraft");
                continue;
            }
            return null;
        }
        return error;
    }
}

