/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.LimitConfig;
import dev.qixils.crowdcontrol.common.command.QuantityStyle;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.commands.ItemCommand;
import dev.qixils.relocated.annotations.Blocking;
import dev.qixils.relocated.annotations.NotNull;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class GiveItemCommand
extends ModdedCommand
implements ItemCommand {
    @NotNull
    private final QuantityStyle quantityStyle = QuantityStyle.APPEND_X;
    private final Item item;
    private final String effectName;
    private final TranslatableComponent defaultDisplayName;

    public GiveItemCommand(ModdedCrowdControlPlugin plugin, Item item) {
        super(plugin);
        this.item = item;
        this.effectName = "give_" + BuiltInRegistries.ITEM.getKey((Object)item).getPath();
        this.defaultDisplayName = Component.translatable((String)"cc.effect.give_item.name", (ComponentLike[])new ComponentLike[]{plugin.toAdventure(item.getName(new ItemStack((ItemLike)item)))});
    }

    @Blocking
    public static void giveItemTo(ServerPlayer player, ItemStack itemStack) {
        ItemEntity entity = player.spawnAtLocation(player.serverLevel(), itemStack);
        if (entity == null) {
            throw new IllegalStateException("Could not spawn item entity");
        }
        entity.setTarget(player.getUUID());
        entity.setThrower((Entity)player);
        entity.setPickUpDelay(0);
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(() -> {
            LimitConfig config = this.getPlugin().getLimitConfig();
            boolean hostsBypass = config.hostsBypass();
            int playerLimit = config.getItemLimit(BuiltInRegistries.ITEM.getKey((Object)this.item).getPath());
            AtomicInteger victims = new AtomicInteger();
            List<ServerPlayer> players = ((List)playerSupplier.get()).stream().sorted(Comparator.comparing(this.plugin::globalEffectsUsableFor)).takeWhile(player -> victims.getAndAdd(1) < playerLimit || hostsBypass && this.plugin.globalEffectsUsableFor(player)).toList();
            int amount = request.getQuantity();
            ItemStack itemStack = new ItemStack((ItemLike)this.item, amount);
            for (ServerPlayer player2 : players) {
                this.sync(() -> GiveItemCommand.giveItemTo(player2, itemStack));
            }
            return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS);
        }));
    }

    @Override
    @NotNull
    public QuantityStyle getQuantityStyle() {
        return this.quantityStyle;
    }

    @Override
    public Item getItem() {
        return this.item;
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }

    @Override
    public TranslatableComponent getDefaultDisplayName() {
        return this.defaultDisplayName;
    }
}

