/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.utils.ItemUtil;
import dev.qixils.relocated.annotations.NotNull;
import java.util.List;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;

public class HatCommand
extends ModdedCommand {
    private final String effectName = "hat";

    public HatCommand(ModdedCrowdControlPlugin plugin) {
        super(plugin);
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(() -> {
            boolean success = false;
            block0: for (ServerPlayer player : (List)playerSupplier.get()) {
                ItemStack head = player.getItemBySlot(EquipmentSlot.HEAD);
                for (InteractionHand handType : InteractionHand.values()) {
                    ItemStack hand = player.getItemInHand(handType);
                    if (ItemUtil.isSimilar(hand, head)) continue;
                    success = true;
                    this.sync(() -> {
                        player.setItemSlot(EquipmentSlot.HEAD, hand);
                        player.setItemInHand(handType, head);
                    });
                    continue block0;
                }
            }
            return success ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Held item(s) and hat are the same");
        }));
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }
}

