/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.utils.BlockFinder;
import dev.qixils.relocated.annotations.NotNull;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Blocks;

public class LavaCommand
extends ModdedCommand {
    private final String effectName = "make_lava";

    public LavaCommand(ModdedCrowdControlPlugin plugin) {
        super(plugin);
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(() -> {
            HashSet locations = new HashSet();
            for (ServerPlayer player : (List)playerSupplier.get()) {
                locations.addAll(((BlockFinder.BlockFinderBuilder)((BlockFinder.BlockFinderBuilder)((BlockFinder.BlockFinderBuilder)BlockFinder.builder().origin((Entity)player).locationValidator(loc -> loc.block().is(Blocks.WATER) || loc.block().is(Blocks.WATER_CAULDRON))).shuffleLocations(false)).maxRadius(10)).build().getAll());
            }
            if (locations.isEmpty()) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "No replaceable blocks nearby");
            }
            this.sync(() -> locations.forEach(loc -> loc.block((loc.block().is(Blocks.WATER_CAULDRON) ? Blocks.LAVA_CAULDRON : Blocks.LAVA).defaultBlockState())));
            return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS);
        }));
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }
}

