/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.relocated.annotations.NotNull;
import java.util.List;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public final class RemoveEnchantsCommand
extends ModdedCommand {
    private final String effectName = "remove_enchants";

    public RemoveEnchantsCommand(ModdedCrowdControlPlugin plugin) {
        super(plugin);
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(() -> {
            boolean success = false;
            block0: for (ServerPlayer player : (List)playerSupplier.get()) {
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    if (!this.tryRemoveEnchants(player.getItemBySlot(slot))) continue;
                    success = true;
                    continue block0;
                }
            }
            return success ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Target was not holding an enchanted item");
        }));
    }

    private boolean tryRemoveEnchants(ItemStack item) {
        if (item.isEmpty()) {
            return false;
        }
        ItemEnchantments enchantments = (ItemEnchantments)item.get(DataComponents.ENCHANTMENTS);
        if (enchantments == null || enchantments.isEmpty()) {
            return false;
        }
        item.set(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        return true;
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }
}

