/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.LimitConfig;
import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.commands.EntityCommand;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.phys.Vec3;

public class RemoveEntityCommand<E extends Entity>
extends ModdedCommand
implements EntityCommand<E> {
    protected final EntityType<? extends E> entityType;
    protected final List<EntityType<? extends E>> entityTypes;
    private final String effectName;
    private final Component displayName;

    public RemoveEntityCommand(ModdedCrowdControlPlugin plugin, EntityType<E> entityType) {
        this(plugin, "remove_entity_" + CommandConstants.csIdOf((Keyed)BuiltInRegistries.ENTITY_TYPE.getKey(entityType)), (Component)Component.translatable((String)"cc.effect.remove_entity.name", (ComponentLike[])new ComponentLike[]{plugin.toAdventure(entityType.getDescription())}), entityType, new EntityType[0]);
    }

    @SafeVarargs
    public RemoveEntityCommand(ModdedCrowdControlPlugin plugin, String effectName, @Nullable Component displayName, EntityType<? extends E> firstEntity, EntityType<? extends E> ... otherEntities) {
        super(plugin);
        this.entityType = firstEntity;
        this.entityTypes = new ArrayList<EntityType<? extends E>>(1 + otherEntities.length);
        this.entityTypes.add(firstEntity);
        this.entityTypes.addAll(Arrays.asList(otherEntities));
        this.effectName = effectName;
        this.displayName = displayName;
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        return this.getDefaultDisplayName();
    }

    @Override
    public boolean isMonster() {
        if (this.entityType == EntityType.ENDER_DRAGON) {
            return false;
        }
        return EntityCommand.super.isMonster();
    }

    private boolean removeEntityFrom(ServerPlayer player) {
        ServerLevel level = player.serverLevel();
        if (this.entityType == EntityType.ENDER_DRAGON && level.getDragonFight() != null) {
            return false;
        }
        Vec3 playerPosition = player.position();
        List<Entity> entities = StreamSupport.stream(level.getAllEntities().spliterator(), false).filter(entity -> this.getEntityTypes().contains(entity.getType()) && entity.distanceToSqr(playerPosition) <= 1225.0).sorted((entity1, entity2) -> (int)(entity1.distanceToSqr(playerPosition) - entity2.distanceToSqr(playerPosition))).toList();
        if (entities.isEmpty()) {
            return false;
        }
        entities.getFirst().remove(Entity.RemovalReason.KILLED);
        return true;
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(() -> {
            CCEffectResponse tryExecute;
            List<ServerPlayer> players = (List<ServerPlayer>)playerSupplier.get();
            LimitConfig config = this.getPlugin().getLimitConfig();
            int playerLimit = config.getEntityLimit(BuiltInRegistries.ENTITY_TYPE.getKey(this.entityType).getPath());
            if (playerLimit > 0) {
                boolean hostsBypass = config.hostsBypass();
                AtomicInteger victims = new AtomicInteger();
                players = players.stream().sorted(Comparator.comparing(this.plugin::globalEffectsUsableFor)).takeWhile(player -> victims.getAndAdd(1) < playerLimit || hostsBypass && this.plugin.globalEffectsUsableFor(player)).toList();
            }
            if ((tryExecute = this.tryExecute(players, request, ccPlayer)) != null) {
                return tryExecute;
            }
            boolean success = false;
            for (ServerPlayer player2 : players) {
                try {
                    success |= this.removeEntityFrom(player2);
                }
                catch (Exception e) {
                    this.plugin.getSLF4JLogger().error("Failed to spawn entity", (Throwable)e);
                }
            }
            return success ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "No " + this.plugin.getTextUtil().asPlain(this.entityType.getDescription()) + "s found nearby to remove");
        }));
    }

    @Override
    public EntityType<? extends E> getEntityType() {
        return this.entityType;
    }

    public List<EntityType<? extends E>> getEntityTypes() {
        return this.entityTypes;
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }
}

