/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.command.impl.Shader;
import dev.qixils.crowdcontrol.common.util.SemVer;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.packets.SetShaderS2C;
import dev.qixils.relocated.annotations.NotNull;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.CCTimedEffect;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCTimedEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.minecraft.server.level.ServerPlayer;

public class ShaderCommand
extends ModdedCommand
implements CCTimedEffect {
    @NotNull
    private final String effectName;
    @NotNull
    private final String shader;
    @NotNull
    private final SemVer minimumModVersion;
    @NotNull
    private final String effectGroup = "shaders";
    @NotNull
    private final List<String> effectGroups = Collections.singletonList("shaders");

    public ShaderCommand(@NotNull ModdedCrowdControlPlugin plugin, @NotNull Shader shader) {
        super(plugin);
        this.effectName = shader.getEffectId();
        this.minimumModVersion = shader.addedIn();
        this.shader = shader.getShaderId();
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(() -> {
            if (this.isActive(ccPlayer, this.getEffectArray())) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "All players already have an active screen effect");
            }
            Duration duration = Duration.ofSeconds(request.getEffect().getDuration());
            SetShaderS2C packet = new SetShaderS2C(this.shader, duration);
            for (ServerPlayer player : (List)playerSupplier.get()) {
                this.plugin.sendToPlayer(player, packet);
            }
            return new CCTimedEffectResponse(request.getRequestId(), ResponseStatus.TIMED_BEGIN, duration.toMillis());
        }));
    }

    @Override
    @NotNull
    public String getEffectName() {
        return this.effectName;
    }

    @NotNull
    public String getShader() {
        return this.shader;
    }

    @Override
    @NotNull
    public SemVer getMinimumModVersion() {
        return this.minimumModVersion;
    }

    @NotNull
    public String getEffectGroup() {
        return this.effectGroup;
    }

    @Override
    @NotNull
    public List<String> getEffectGroups() {
        return this.effectGroups;
    }
}

