/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.TriState;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.utils.Location;
import dev.qixils.relocated.annotations.NotNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.IUserRecord;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class SwapCommand
extends ModdedCommand {
    private final String effectName = "swap";

    public SwapCommand(ModdedCrowdControlPlugin plugin) {
        super(plugin);
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(() -> {
            List players = (List)playerSupplier.get();
            if (players.size() < 2) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Not enough participating players online");
            }
            ArrayList offset = new ArrayList(players.size());
            offset.addAll(players.subList(1, players.size()));
            offset.add((ServerPlayer)players.getFirst());
            HashMap<ServerPlayer, Location> destinations = new HashMap<ServerPlayer, Location>(players.size());
            for (int i = 0; i < players.size(); ++i) {
                destinations.put((ServerPlayer)players.get(i), new Location((Entity)offset.get(i)));
            }
            this.sync(() -> destinations.forEach((player, location) -> location.teleportHere((ServerPlayer)player)));
            return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS);
        }));
    }

    @Override
    public TriState isSelectable(@NotNull IUserRecord user, @NotNull List<ServerPlayer> potentialPlayers) {
        return potentialPlayers.size() <= 1 ? TriState.FALSE : TriState.TRUE;
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }
}

