/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.LimitConfig;
import dev.qixils.crowdcontrol.common.command.QuantityStyle;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.commands.ItemCommand;
import dev.qixils.crowdcontrol.plugin.fabric.utils.InventoryUtil;
import dev.qixils.relocated.annotations.NotNull;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class TakeItemCommand
extends ModdedCommand
implements ItemCommand {
    @NotNull
    private final QuantityStyle quantityStyle = QuantityStyle.APPEND_X;
    private final Item item;
    private final String effectName;
    private final TranslatableComponent defaultDisplayName;

    public TakeItemCommand(ModdedCrowdControlPlugin plugin, Item item) {
        super(plugin);
        this.item = item;
        this.effectName = "take_" + BuiltInRegistries.ITEM.getKey((Object)item).getPath();
        this.defaultDisplayName = Component.translatable((String)"cc.effect.take_item.name", (ComponentLike[])new ComponentLike[]{plugin.toAdventure(item.getName(new ItemStack((ItemLike)item)))});
    }

    private boolean takeItemFrom(Player player, int amount) {
        Inventory inventory = player.getInventory();
        int toTake = 0;
        for (ItemStack itemStack : InventoryUtil.viewAllItems(inventory)) {
            if (!itemStack.isEmpty() && itemStack.getItem() == this.item && (toTake += itemStack.getCount()) >= amount) break;
        }
        if (toTake < amount) {
            return false;
        }
        toTake = amount;
        for (ItemStack itemStack : InventoryUtil.viewAllItems(inventory)) {
            if (itemStack.isEmpty() || itemStack.getItem() != this.item) continue;
            int take = Math.min(toTake, itemStack.getCount());
            itemStack.shrink(take);
            if ((toTake -= take) != 0) continue;
            break;
        }
        return true;
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(() -> {
            List<ServerPlayer> players = (List<ServerPlayer>)playerSupplier.get();
            LimitConfig config = this.getPlugin().getLimitConfig();
            int playerLimit = config.getItemLimit(BuiltInRegistries.ITEM.getKey((Object)this.item).getPath());
            if (playerLimit > 0) {
                boolean hostsBypass = config.hostsBypass();
                AtomicInteger victims = new AtomicInteger();
                players = players.stream().sorted(Comparator.comparing(this.plugin::globalEffectsUsableFor)).takeWhile(player -> victims.getAndAdd(1) < playerLimit || hostsBypass && this.plugin.globalEffectsUsableFor(player)).toList();
            }
            int amount = request.getQuantity();
            boolean success = false;
            for (ServerPlayer player2 : players) {
                success |= this.takeItemFrom((Player)player2, amount);
            }
            return success ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Item could not be found in target inventories");
        }));
    }

    @Override
    @NotNull
    public QuantityStyle getQuantityStyle() {
        return this.quantityStyle;
    }

    @Override
    public Item getItem() {
        return this.item;
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }

    @Override
    public TranslatableComponent getDefaultDisplayName() {
        return this.defaultDisplayName;
    }
}

