/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.util.RandomUtil;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.common.util.Weighted;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.utils.BlockFinder;
import dev.qixils.crowdcontrol.plugin.fabric.utils.Location;
import dev.qixils.relocated.annotations.Contract;
import dev.qixils.relocated.annotations.NotNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class VeinCommand
extends ModdedCommand {
    private final String effectName = "vein";

    public VeinCommand(ModdedCrowdControlPlugin plugin) {
        super(plugin);
    }

    @Contract(mutates="param1, param2")
    private void addOreVein(List<Location> deepslateBlocks, List<Location> stoneBlocks, Location base) {
        for (int x = 0; x <= 1; ++x) {
            for (int y = 0; y <= 1; ++y) {
                for (int z = 0; z <= 1; ++z) {
                    Location loc = base.add(x, y, z);
                    BlockState block = loc.block();
                    Block matType = block.getBlock();
                    if (matType == Blocks.DEEPSLATE) {
                        deepslateBlocks.add(loc);
                        continue;
                    }
                    if (block.isAir()) continue;
                    stoneBlocks.add(loc);
                }
            }
        }
    }

    @Contract(mutates="param1")
    private static void randomlyShrinkOreVein(List<Location> blockLocations) {
        if (blockLocations.isEmpty()) {
            return;
        }
        Collections.shuffle(blockLocations, random);
        int maxBlocks = 1 + random.nextInt(blockLocations.size());
        while (blockLocations.size() > maxBlocks) {
            blockLocations.removeFirst();
        }
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(() -> {
            boolean success = false;
            for (ServerPlayer player : (List)playerSupplier.get()) {
                BlockFinder finder = ((BlockFinder.BlockFinderBuilder)((BlockFinder.BlockFinderBuilder)BlockFinder.builder().origin(new Location((Entity)player)).maxRadius(6)).locationValidator(loc -> !loc.block().isAir())).build();
                for (int iter = 0; iter < 2; ++iter) {
                    Ores ore = (Ores)RandomUtil.weightedRandom((Weighted[])Ores.values(), (int)Ores.TOTAL_WEIGHTS);
                    ArrayList<Location> setBlocks = new ArrayList<Location>(8);
                    ArrayList<Location> setDeepslateBlocks = new ArrayList<Location>(8);
                    Location oreLocation = (Location)finder.next();
                    if (oreLocation == null) continue;
                    this.addOreVein(setDeepslateBlocks, setBlocks, oreLocation);
                    if (setBlocks.isEmpty() && setDeepslateBlocks.isEmpty()) continue;
                    success = true;
                    VeinCommand.randomlyShrinkOreVein(setBlocks);
                    VeinCommand.randomlyShrinkOreVein(setDeepslateBlocks);
                    this.sync(() -> {
                        setBlocks.forEach(blockPos -> blockPos.block(ore.getBlock().defaultBlockState()));
                        setDeepslateBlocks.forEach(blockPos -> blockPos.block(ore.getDeepslateBlock().defaultBlockState()));
                    });
                }
            }
            return success ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Could not find any blocks to replace");
        }));
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }

    public static enum Ores implements Weighted
    {
        DIAMOND(Blocks.DIAMOND_ORE, Blocks.DEEPSLATE_DIAMOND_ORE, 3),
        IRON(Blocks.IRON_ORE, Blocks.DEEPSLATE_IRON_ORE, 3),
        COAL(Blocks.COAL_ORE, Blocks.DEEPSLATE_COAL_ORE, 3),
        EMERALD(Blocks.EMERALD_ORE, Blocks.DEEPSLATE_EMERALD_ORE, 3),
        GOLD(Blocks.GOLD_ORE, Blocks.DEEPSLATE_GOLD_ORE, 3),
        REDSTONE(Blocks.REDSTONE_ORE, Blocks.DEEPSLATE_REDSTONE_ORE, 3),
        LAPIS(Blocks.LAPIS_ORE, Blocks.DEEPSLATE_LAPIS_ORE, 3),
        ANCIENT_DEBRIS(Blocks.ANCIENT_DEBRIS, 1),
        QUARTZ(Blocks.NETHER_QUARTZ_ORE, 3),
        NETHER_GOLD(Blocks.NETHER_GOLD_ORE, 3),
        SILVERFISH(Blocks.INFESTED_STONE, Blocks.INFESTED_DEEPSLATE, 2),
        LAVA(Blocks.LAVA, 8);

        public static final int TOTAL_WEIGHTS;
        private final Block block;
        private final Block deepslateBlock;
        private final int weight;

        private Ores(Block block, Block deepslateBlock, int weight) {
            this.block = block;
            this.deepslateBlock = deepslateBlock;
            this.weight = weight;
        }

        private Ores(Block block, int weight) {
            this(block, block, weight);
        }

        public Block getBlock() {
            return this.block;
        }

        public Block getDeepslateBlock() {
            return this.deepslateBlock;
        }

        @Override
        public int getWeight() {
            return this.weight;
        }

        static {
            TOTAL_WEIGHTS = Arrays.stream(Ores.values()).mapToInt(Ores::getWeight).sum();
        }
    }
}

