/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.Global;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.relocated.annotations.NotNull;
import java.util.List;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

@Global
public class WeatherCommand
extends ModdedCommand {
    private final int ticks = 72000;
    private final String effectName;
    private final boolean rain;
    private final boolean storm;

    private WeatherCommand(ModdedCrowdControlPlugin plugin, String effectName, boolean rain, boolean storm) {
        super(plugin);
        this.effectName = effectName;
        this.rain = rain;
        this.storm = storm;
        if (storm && !rain) {
            throw new IllegalArgumentException("Storms can only be used with rain");
        }
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(() -> {
            playerSupplier.get();
            boolean success = false;
            for (ServerLevel world : this.plugin.server().getAllLevels()) {
                if (!world.dimension().location().getPath().equals("overworld") || this.storm && world.isThundering() || this.rain && world.isRaining() || !this.rain && !world.isRaining() && !world.isThundering()) continue;
                if (!this.rain) {
                    this.sync(() -> world.setWeatherParameters(72000, 0, false, false));
                } else {
                    this.sync(() -> world.setWeatherParameters(0, 72000, true, this.storm));
                }
                success = true;
            }
            return success ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Requested weather is already active");
        }));
    }

    public static WeatherCommand clear(ModdedCrowdControlPlugin plugin) {
        return new WeatherCommand(plugin, "clear", false, false);
    }

    public static WeatherCommand downfall(ModdedCrowdControlPlugin plugin) {
        return new WeatherCommand(plugin, "downfall", true, false);
    }

    public static WeatherCommand storm(ModdedCrowdControlPlugin plugin) {
        return new WeatherCommand(plugin, "thunder_storm", true, true);
    }

    public int getTicks() {
        return this.ticks;
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }

    public boolean isRain() {
        return this.rain;
    }

    public boolean isStorm() {
        return this.storm;
    }
}

