/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.mixin;

import dev.qixils.crowdcontrol.common.components.MovementStatusType;
import dev.qixils.crowdcontrol.common.components.MovementStatusValue;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={Entity.class})
public class EntityMixin {
    @ModifyVariable(method={"turn(DD)V"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    public double modifyYaw(double yaw) {
        EntityMixin entityMixin = this;
        if (!(entityMixin instanceof Player)) {
            return yaw;
        }
        Player player = (Player)entityMixin;
        MovementStatusValue value = player.cc$getMovementStatus(MovementStatusType.LOOK);
        if (value == MovementStatusValue.INVERTED) {
            return -yaw;
        }
        if (value == MovementStatusValue.DENIED) {
            return 0.0;
        }
        return yaw;
    }

    @ModifyVariable(method={"turn(DD)V"}, at=@At(value="HEAD"), ordinal=1, argsOnly=true)
    public double modifyPitch(double pitch) {
        EntityMixin entityMixin = this;
        if (!(entityMixin instanceof Player)) {
            return pitch;
        }
        Player player = (Player)entityMixin;
        MovementStatusValue value = player.cc$getMovementStatus(MovementStatusType.LOOK);
        if (value == MovementStatusValue.INVERTED) {
            return -pitch;
        }
        if (value == MovementStatusValue.DENIED || value == MovementStatusValue.PARTIAL) {
            return 0.0;
        }
        return pitch;
    }
}

