/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.utils;

import dev.qixils.relocated.annotations.Nullable;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)"CrowdControl/AttributeUtil");

    public static ResourceLocation migrateId(UUID uuid) {
        return ResourceLocation.withDefaultNamespace((String)uuid.toString().toLowerCase(Locale.US));
    }

    public static Optional<AttributeModifier> getModifier(@Nullable AttributeInstance attr, UUID uuid) {
        if (attr == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(attr.getModifier(AttributeUtil.migrateId(uuid)));
    }

    public static Optional<AttributeModifier> getModifier(LivingEntity player, Holder<Attribute> attribute, UUID uuid) {
        return AttributeUtil.getModifier(player.getAttribute(attribute), uuid);
    }

    public static void removeModifier(@Nullable AttributeInstance attr, UUID uuid) {
        if (attr == null) {
            return;
        }
        attr.removeModifier(AttributeUtil.migrateId(uuid));
    }

    public static void removeModifier(LivingEntity player, Holder<Attribute> attribute, UUID uuid) {
        AttributeUtil.removeModifier(player.getAttribute(attribute), uuid);
    }

    public static void addModifier(AttributeInstance attr, UUID uuid, double level, AttributeModifier.Operation op, boolean permanent) {
        AttributeUtil.removeModifier(attr, uuid);
        if (level == 0.0) {
            return;
        }
        Consumer<AttributeModifier> func = permanent ? arg_0 -> ((AttributeInstance)attr).addTransientModifier(arg_0) : arg_0 -> ((AttributeInstance)attr).addPermanentModifier(arg_0);
        func.accept(new AttributeModifier(AttributeUtil.migrateId(uuid), level, op));
    }

    public static void addModifier(LivingEntity player, Holder<Attribute> attributeHolder, UUID uuid, double level, AttributeModifier.Operation op, boolean permanent) {
        AttributeInstance attr = player.getAttribute(attributeHolder);
        if (attr == null) {
            logger.warn("Player missing {} attribute", attributeHolder.unwrapKey().orElse(null));
            return;
        }
        AttributeUtil.addModifier(attr, uuid, level, op, permanent);
    }
}

