/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.utils;

import dev.qixils.crowdcontrol.plugin.fabric.utils.ParticleEffectBuilder;
import dev.qixils.relocated.annotations.CheckReturnValue;
import dev.qixils.relocated.annotations.Contract;
import java.util.Collections;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.joml.Vector3f;

@FieldsAreNonnullByDefault
@MethodsReturnNonnullByDefault
public record Location(ServerLevel level, double x, double y, double z, float yaw, float pitch) {
    public Location(Entity player) {
        this((ServerLevel)player.level(), player.getX(), player.getY(), player.getZ(), player.getYRot(), player.getXRot());
    }

    public Location(ServerLevel level, double x, double y, double z) {
        this(level, x, y, z, 0.0f, 0.0f);
    }

    public Location(ServerLevel level, BlockPos pos, float yaw, float pitch) {
        this(level, pos.getX(), pos.getY(), pos.getZ(), yaw, pitch);
    }

    public Location(ServerLevel level, BlockPos pos) {
        this(level, pos.getX(), (double)pos.getY(), (double)pos.getZ());
    }

    public BlockPos pos() {
        return BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
    }

    public Vec3 vec3() {
        return new Vec3(this.x, this.y, this.z);
    }

    public Vector3d vector3d() {
        return new Vector3d(this.x, this.y, this.z);
    }

    public Vector3f vector3f() {
        return new Vector3f((float)this.x, (float)this.y, (float)this.z);
    }

    public void teleportHere(ServerPlayer player) {
        player.teleportTo(this.level, this.x, this.y, this.z, Collections.emptySet(), this.yaw, this.pitch, false);
    }

    @CheckReturnValue
    @Contract(value="_, _, _ -> new")
    public Location add(double x, double y, double z) {
        return new Location(this.level, this.x + x, this.y + y, this.z + z, this.yaw, this.pitch);
    }

    @CheckReturnValue
    @Contract(value="-> new")
    public Location atVertCeil() {
        return new Location(this.level, this.x, Math.ceil(this.y), this.z, this.yaw, this.pitch);
    }

    @CheckReturnValue
    @Contract(value="_ -> new")
    public Location at(BlockPos pos) {
        return new Location(this.level, pos, this.yaw, this.pitch);
    }

    @CheckReturnValue
    @Contract(value="_, _ -> new")
    public Location withRotation(float yaw, float pitch) {
        return new Location(this.level, this.x, this.y, this.z, yaw, pitch);
    }

    @CheckReturnValue
    @Contract(value="_ -> new")
    public Location withRotationOf(Location other) {
        return new Location(this.level, this.x, this.y, this.z, other.yaw, other.pitch);
    }

    @CheckReturnValue
    @Contract(value="_, _, _ -> new")
    public Location withPosition(double x, double y, double z) {
        return new Location(this.level, x, y, z, this.yaw, this.pitch);
    }

    @CheckReturnValue
    @Contract(value="_ -> new")
    public Location withPositionOf(Location other) {
        return new Location(other.level, other.x, other.y, other.z, this.yaw, this.pitch);
    }

    public BlockState block() {
        return this.level.getBlockState(this.pos());
    }

    public void block(BlockState state) {
        this.level.setBlockAndUpdate(this.pos(), state);
    }

    public <T extends ParticleOptions> ParticleEffectBuilder<T> buildParticleEffect(T options) {
        return new ParticleEffectBuilder<T>(options).level(this.level).position(this.vector3d());
    }

    public Location relative(Direction direction) {
        return new Location(this.level, this.x + (double)direction.getStepX(), this.y + (double)direction.getStepY(), this.z + (double)direction.getStepZ(), this.yaw, this.pitch);
    }

    public double squareDistanceTo(Location o) {
        return Math.pow(this.x - o.x, 2.0) + Math.pow(this.y - o.y, 2.0) + Math.pow(this.z - o.z, 2.0);
    }
}

