/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.relocated.adventure.minimessage.internal.parser;

import dev.qixils.relocated.adventure.minimessage.internal.parser.TokenType;
import dev.qixils.relocated.annotations.NotNull;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.adventure.internal.Internals;
import net.kyori.examination.Examinable;
import net.kyori.examination.ExaminableProperty;

public final class Token
implements Examinable {
    private final int startIndex;
    private final int endIndex;
    private final TokenType type;
    private List<Token> childTokens = null;

    public Token(int startIndex, int endIndex, TokenType type) {
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.type = type;
    }

    public int startIndex() {
        return this.startIndex;
    }

    public int endIndex() {
        return this.endIndex;
    }

    public TokenType type() {
        return this.type;
    }

    public List<Token> childTokens() {
        return this.childTokens;
    }

    public void childTokens(List<Token> childTokens) {
        this.childTokens = childTokens;
    }

    public CharSequence get(CharSequence message) {
        return message.subSequence(this.startIndex, this.endIndex);
    }

    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of((String)"startIndex", (int)this.startIndex), ExaminableProperty.of((String)"endIndex", (int)this.endIndex), ExaminableProperty.of((String)"type", (Object)((Object)this.type)));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Token)) {
            return false;
        }
        Token that = (Token)other;
        return this.startIndex == that.startIndex && this.endIndex == that.endIndex && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.startIndex, this.endIndex, this.type});
    }

    public String toString() {
        return Internals.toString((Examinable)this);
    }
}

