/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric;

import dev.qixils.crowdcontrol.common.AbstractPlayerManager;
import dev.qixils.crowdcontrol.common.util.PermissionWrapper;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class MojmapPlayerManager
extends AbstractPlayerManager<ServerPlayer> {
    private final ModdedCrowdControlPlugin plugin;

    @Override
    @NotNull
    public @NotNull List<@NotNull ServerPlayer> getAllPlayersFull() {
        if (this.getPlugin().getTheGame() == null) {
            return Collections.emptyList();
        }
        return new ArrayList<ServerPlayer>(this.getPlugin().getTheGame().playerList().getPlayers());
    }

    @Override
    public boolean canApply(@NotNull ServerPlayer player, @Nullable PublicEffectPayload request) {
        if (player.isDeadOrDying()) {
            return false;
        }
        if (this.isSpectator(player)) {
            return false;
        }
        if (!this.plugin.getPermissionUtil().check((Entity)player, this.plugin.getUsePermission())) {
            return false;
        }
        PermissionWrapper perm = this.getEffectPermission(request).orElse(null);
        return perm == null || this.plugin.getPermissionUtil().check((Entity)player, perm);
    }

    @Override
    public boolean isSpectator(@NotNull ServerPlayer player) {
        return player.isSpectator() && player.cc$getGameTypeEffect() == null;
    }

    public ModdedCrowdControlPlugin getPlugin() {
        return this.plugin;
    }

    public MojmapPlayerManager(ModdedCrowdControlPlugin plugin) {
        this.plugin = plugin;
    }
}

