/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import com.google.common.collect.Lists;
import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.common.util.RandomUtil;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.common.util.Weighted;
import dev.qixils.crowdcontrol.common.util.sound.Sounds;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.utils.AttributeUtil;
import dev.qixils.relocated.annotations.Contract;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Unit;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.level.ItemLike;

public class LootboxCommand
extends ModdedCommand {
    private static final List<Holder<Attribute>> ATTRIBUTES = Arrays.asList(Attributes.MAX_HEALTH, Attributes.KNOCKBACK_RESISTANCE, Attributes.MOVEMENT_SPEED, Attributes.ATTACK_DAMAGE, Attributes.ARMOR, Attributes.ARMOR_TOUGHNESS, Attributes.ATTACK_KNOCKBACK, Attributes.ATTACK_SPEED);
    private static final List<DataComponentType<?>> CURSES = List.of(EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE, EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP);
    private static final Map<EquipmentSlot, EquipmentSlotGroup> SLOT_TO_GROUP = Map.of(EquipmentSlot.MAINHAND, EquipmentSlotGroup.MAINHAND, EquipmentSlot.OFFHAND, EquipmentSlotGroup.OFFHAND, EquipmentSlot.HEAD, EquipmentSlotGroup.HEAD, EquipmentSlot.CHEST, EquipmentSlotGroup.CHEST, EquipmentSlot.LEGS, EquipmentSlotGroup.LEGS, EquipmentSlot.FEET, EquipmentSlotGroup.FEET);
    public static final Map<UUID, ChestMenu> OPEN_LOOTBOXES = new HashMap<UUID, ChestMenu>();
    public static final Map<UUID, net.minecraft.network.chat.Component> TITLES = new HashMap<UUID, net.minecraft.network.chat.Component>();
    private final List<Item> allItems;
    private final List<Item> goodItems;
    private final String effectName;
    private final int luck;

    public LootboxCommand(ModdedCrowdControlPlugin plugin, int luck) {
        super(plugin);
        this.luck = luck;
        StringBuilder effectName = new StringBuilder("lootbox");
        if (luck > 0) {
            effectName.append('_').append(luck);
        }
        this.effectName = effectName.toString();
        this.allItems = BuiltInRegistries.ITEM.stream().filter(it -> it != Items.AIR).toList();
        this.goodItems = this.allItems.stream().filter(itemType -> (Integer)itemType.components().getOrDefault(DataComponents.MAX_DAMAGE, (Object)0) > 1 || itemType == Items.GOLDEN_APPLE || itemType == Items.ENCHANTED_GOLDEN_APPLE || itemType == Items.NETHERITE_BLOCK || itemType == Items.DIAMOND_BLOCK || itemType == Items.IRON_BLOCK || itemType == Items.GOLD_BLOCK).collect(Collectors.toList());
    }

    private static boolean isLootboxOpen(@NotNull Player player) {
        UUID uuid = player.getUUID();
        if (!OPEN_LOOTBOXES.containsKey(uuid)) {
            return false;
        }
        ChestMenu inv = OPEN_LOOTBOXES.get(uuid);
        if (inv.getContainer().isEmpty() || !inv.stillValid(player) || player.containerMenu != inv) {
            OPEN_LOOTBOXES.remove(uuid);
            return false;
        }
        return true;
    }

    public static void onInventoryClose(ServerPlayer player) {
        if (!ModdedCrowdControlPlugin.isInstanceAvailable()) {
            return;
        }
        ModdedCrowdControlPlugin plugin = ModdedCrowdControlPlugin.getInstance();
        UUID uuid = player.getUUID();
        if (!LootboxCommand.isLootboxOpen((Player)player)) {
            return;
        }
        ChestMenu lootbox = OPEN_LOOTBOXES.get(uuid);
        plugin.getSyncExecutor().execute(() -> {
            OptionalInt status = player.openMenu((MenuProvider)new SimpleMenuProvider((i, inventory, p) -> ChestMenu.threeRows((int)i, (Inventory)inventory, (Container)lootbox.getContainer()), TITLES.get(uuid)));
            if (status.isEmpty()) {
                OPEN_LOOTBOXES.remove(uuid);
            }
            OPEN_LOOTBOXES.put(uuid, (ChestMenu)player.containerMenu);
        });
    }

    private boolean isGoodItem(@Nullable Item item) {
        return item != null && this.goodItems.contains(item);
    }

    public ItemStack createRandomItem(int luck, @Nullable RegistryAccess registryAccess) {
        ArrayList<Item> items = new ArrayList<Item>(this.allItems);
        items.removeIf(this.plugin::isDisabled);
        Collections.shuffle(items, random);
        Item item = null;
        for (int i = 0; i <= luck * 5; ++i) {
            Item oldItem = item;
            item = (Item)items.get(i);
            if (this.isGoodItem(item) && !this.isGoodItem(oldItem)) break;
        }
        assert (item != null);
        int quantity = 1;
        int maxStackSize = (Integer)item.components().getOrDefault(DataComponents.MAX_STACK_SIZE, (Object)0);
        if (maxStackSize > 1) {
            for (int i = 0; i <= luck; ++i) {
                quantity = Math.max(quantity, RandomUtil.nextInclusiveInt(1, maxStackSize));
            }
        }
        ItemStack itemStack = new ItemStack((ItemLike)item, quantity);
        this.randomlyModifyItem(itemStack, luck, registryAccess);
        return itemStack;
    }

    @Contract(mutates="param1")
    public void randomlyModifyItem(ItemStack itemStack, int luck, @Nullable RegistryAccess registryAccess) {
        if (registryAccess == null) {
            registryAccess = this.plugin.theGame().registryAccess();
        }
        if (random.nextDouble() >= 0.95 - (double)luck * 0.1) {
            itemStack.set(DataComponents.UNBREAKABLE, (Object)Unit.INSTANCE);
        }
        if (random.nextInt(4) == 0) {
            itemStack.set(DataComponents.TRIM, (Object)new ArmorTrim((Holder)RandomUtil.randomElementFrom(this.plugin.registryHolders(Registries.TRIM_MATERIAL, registryAccess)), (Holder)RandomUtil.randomElementFrom(this.plugin.registryHolders(Registries.TRIM_PATTERN, registryAccess))));
        }
        int _enchantments = 0;
        for (int i = 0; i <= luck; ++i) {
            _enchantments = Math.max(_enchantments, ((CommandConstants.EnchantmentWeights)RandomUtil.weightedRandom((Weighted[])CommandConstants.EnchantmentWeights.values(), (int)CommandConstants.EnchantmentWeights.TOTAL_WEIGHTS)).getLevel());
        }
        int enchantments = _enchantments;
        List enchantmentList = this.plugin.registry(Registries.ENCHANTMENT, registryAccess).listElements().filter(enchantmentHolder -> ((Enchantment)enchantmentHolder.value()).canEnchant(itemStack)).collect(Collectors.toList());
        if (random.nextDouble() >= 0.8 - (double)luck * 0.2) {
            for (DataComponentType<?> curse : CURSES) {
                enchantmentList.removeIf(holder -> ((Enchantment)holder.value()).effects().has(curse));
            }
        }
        ArrayList<Holder> addedEnchantments = new ArrayList<Holder>(enchantments);
        while (addedEnchantments.size() < enchantments && !enchantmentList.isEmpty()) {
            Holder enchantment = (Holder)enchantmentList.removeFirst();
            if (addedEnchantments.stream().anyMatch(x -> Enchantment.areCompatible((Holder)x, (Holder)enchantment)) && random.nextDouble() >= 0.1 + (double)luck * 0.1) continue;
            addedEnchantments.add(enchantment);
            int level = ((Enchantment)enchantment.value()).getMinLevel();
            if (((Enchantment)enchantment.value()).getMaxLevel() > level) {
                for (int j = 0; j <= luck; ++j) {
                    level = Math.max(level, RandomUtil.nextInclusiveInt(((Enchantment)enchantment.value()).getMinLevel(), ((Enchantment)enchantment.value()).getMaxLevel()));
                }
                if (random.nextDouble() >= 0.5 - (double)luck * 0.07) {
                    level += random.nextInt(4);
                }
            }
            itemStack.enchant(enchantment, level);
        }
        int attributes = 0;
        for (int i = 0; i <= luck; ++i) {
            attributes = Math.max(attributes, ((CommandConstants.AttributeWeights)RandomUtil.weightedRandom((Weighted[])CommandConstants.AttributeWeights.values(), (int)CommandConstants.AttributeWeights.TOTAL_WEIGHTS)).getLevel());
        }
        if (attributes > 0) {
            ArrayList<Holder<Attribute>> attributeList = new ArrayList<Holder<Attribute>>(ATTRIBUTES);
            Collections.shuffle(attributeList, random);
            for (int i = 0; i < attributeList.size() && i < attributes; ++i) {
                Holder attribute = (Holder)attributeList.get(i);
                double amount = 0.0;
                for (int j = 0; j <= luck; ++j) {
                    amount = Math.max(amount, random.nextDouble() * 2.0 - 1.0);
                }
                AttributeModifier attributeModifier = new AttributeModifier(AttributeUtil.migrateId(UUID.randomUUID()), amount, AttributeModifier.Operation.ADD_VALUE);
                ItemAttributeModifiers modifiers = (ItemAttributeModifiers)itemStack.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
                modifiers = modifiers.withModifierAdded(attribute, attributeModifier, EquipmentSlotGroup.ANY);
                itemStack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)modifiers);
            }
        }
    }

    private List<Component> getLore(ItemStack itemStack) {
        ItemLore itemLore = (ItemLore)itemStack.get(DataComponents.LORE);
        if (itemLore == null || itemLore.lines().isEmpty()) {
            return new ArrayList<Component>();
        }
        return itemLore.lines().stream().map(this.plugin::toAdventure).collect(Collectors.toList());
    }

    private void setLore(ItemStack itemStack, List<Component> lore) {
        if (lore.isEmpty()) {
            itemStack.remove(DataComponents.LORE);
            return;
        }
        List nativeLore = Lists.transform(lore, component -> this.plugin.adventure().asNative(component));
        itemStack.set(DataComponents.LORE, (Object)new ItemLore(nativeLore));
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            boolean success = false;
            List players = (List)playerSupplier.get();
            for (ServerPlayer player : players) {
                if (LootboxCommand.isLootboxOpen((Player)player)) continue;
                SimpleContainer container = new SimpleContainer(27);
                for (int slot : CommandConstants.lootboxItemSlots(this.luck)) {
                    ItemStack itemStack = this.createRandomItem(this.luck, player.registryAccess());
                    List<Component> lore = this.getLore(itemStack);
                    lore.add(this.plugin.adventure().renderer().render(CommandConstants.buildLootboxLore(this.plugin, request), (Object)player));
                    this.setLore(itemStack, lore);
                    container.setItem(slot, itemStack);
                }
                net.minecraft.network.chat.Component title = this.plugin.adventure().asNative(CommandConstants.buildLootboxTitle(this.plugin, request));
                OptionalInt val = player.openMenu((MenuProvider)new SimpleMenuProvider((i, inventory, p) -> ChestMenu.threeRows((int)i, (Inventory)inventory, (Container)container), title));
                if (val.isEmpty()) continue;
                player.playSound(Sounds.LOOTBOX_CHIME.get(this.luck), Sound.Emitter.self());
                OPEN_LOOTBOXES.put(player.getUUID(), (ChestMenu)player.containerMenu);
                TITLES.put(player.getUUID(), title);
                success = true;
            }
            return success ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Player has another lootbox open");
        }, this.plugin.getSyncExecutor()));
    }

    public List<Item> getAllItems() {
        return this.allItems;
    }

    public List<Item> getGoodItems() {
        return this.goodItems;
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }

    public int getLuck() {
        return this.luck;
    }
}

