/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.qixils.crowdcontrol.common.components.MovementStatusType;
import dev.qixils.crowdcontrol.common.components.MovementStatusValue;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.client.ModdedPlatformClient;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.checkerframework.checker.nullness.qual.Nullable;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.player.ClientInput;
import net.minecraft.client.player.KeyboardInput;
import net.minecraft.client.player.LocalPlayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={KeyboardInput.class})
public abstract class KeyboardInputMixin
extends ClientInput {
    @Unique
    private boolean cc$handleIsDown(@NotNull Function<KeyMapping, Boolean> getResult, @NotNull KeyMapping original, @Nullable KeyMapping inverse, @NotNull MovementStatusType type) {
        if (!ModdedCrowdControlPlugin.CLIENT_INITIALIZED) {
            return getResult.apply(original);
        }
        Optional<LocalPlayer> player = ModdedPlatformClient.get().player();
        if (player.isEmpty()) {
            return getResult.apply(original);
        }
        MovementStatusValue status = player.get().cc$getMovementStatus(type);
        if (status == MovementStatusValue.DENIED) {
            return false;
        }
        if (status == MovementStatusValue.INVERTED && inverse != null) {
            return getResult.apply(inverse);
        }
        return getResult.apply(original);
    }

    @WrapOperation(method={"tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/KeyMapping;isDown()Z", ordinal=0)})
    public boolean isForwardDown(KeyMapping keyMapping, Operation<Boolean> original) {
        return this.cc$handleIsDown(xva$0 -> (Boolean)original.call(new Object[]{xva$0}), keyMapping, ((KeyboardInput)this).options.keyDown, MovementStatusType.WALK);
    }

    @WrapOperation(method={"tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/KeyMapping;isDown()Z", ordinal=1)})
    public boolean isBackDown(KeyMapping keyMapping, Operation<Boolean> original) {
        return this.cc$handleIsDown(xva$0 -> (Boolean)original.call(new Object[]{xva$0}), keyMapping, ((KeyboardInput)this).options.keyUp, MovementStatusType.WALK);
    }

    @WrapOperation(method={"tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/KeyMapping;isDown()Z", ordinal=2)})
    public boolean isLeftDown(KeyMapping keyMapping, Operation<Boolean> original) {
        return this.cc$handleIsDown(xva$0 -> (Boolean)original.call(new Object[]{xva$0}), keyMapping, ((KeyboardInput)this).options.keyRight, MovementStatusType.WALK);
    }

    @WrapOperation(method={"tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/KeyMapping;isDown()Z", ordinal=3)})
    public boolean isRightDown(KeyMapping keyMapping, Operation<Boolean> original) {
        return this.cc$handleIsDown(xva$0 -> (Boolean)original.call(new Object[]{xva$0}), keyMapping, ((KeyboardInput)this).options.keyLeft, MovementStatusType.WALK);
    }

    @WrapOperation(method={"tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/KeyMapping;isDown()Z", ordinal=5)})
    public boolean isSprintDown(KeyMapping keyMapping, Operation<Boolean> original) {
        return this.cc$handleIsDown(xva$0 -> (Boolean)original.call(new Object[]{xva$0}), keyMapping, null, MovementStatusType.WALK);
    }
}

