/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.utils;

import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.commands.KeepInventoryCommand;
import dev.qixils.crowdcontrol.plugin.fabric.event.Damage;
import dev.qixils.crowdcontrol.plugin.fabric.event.Death;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.GameRules;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class EntityUtil {
    private EntityUtil() {
    }

    public static boolean keepInventoryRedirect(Entity entity, boolean keepInventory, GameRules.Key<GameRules.BooleanValue> key) {
        if (key != GameRules.RULE_KEEPINVENTORY) {
            return keepInventory;
        }
        if (keepInventory) {
            return true;
        }
        return KeepInventoryCommand.isKeepingInventory(entity);
    }

    public static void handleDie(LivingEntity entity, DamageSource cause, CallbackInfo ci) {
        if (entity.level().isClientSide) {
            return;
        }
        if (!ModdedCrowdControlPlugin.isInstanceAvailable()) {
            return;
        }
        if (entity.dead) {
            return;
        }
        Death event = new Death(entity, cause);
        event.fire(ModdedCrowdControlPlugin.getInstance());
        if (event.cancelled()) {
            ci.cancel();
        }
    }

    public static void handleDamage(Entity entity, DamageSource cause, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (entity.level().isClientSide) {
            return;
        }
        if (!ModdedCrowdControlPlugin.isInstanceAvailable()) {
            return;
        }
        Damage event = new Damage(entity, cause, amount);
        event.fire(ModdedCrowdControlPlugin.getInstance());
        if (event.cancelled()) {
            cir.setReturnValue((Object)false);
        }
    }
}

