/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.minecraft.extras.parser;

import dev.qixils.relocated.adventure.minimessage.MiniMessage;
import dev.qixils.relocated.adventure.serializer.legacy.LegacyComponentSerializer;
import io.leangen.geantyref.TypeToken;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.apiguardian.api.API;
import org.incendo.cloud.minecraft.extras.MinecraftExtrasParserParameters;
import org.incendo.cloud.minecraft.extras.annotation.specifier.Decoder;
import org.incendo.cloud.minecraft.extras.parser.ComponentParser;
import org.incendo.cloud.parser.ParserContributor;
import org.incendo.cloud.parser.ParserParameters;
import org.incendo.cloud.parser.ParserRegistry;
import org.incendo.cloud.parser.StandardParameters;
import org.incendo.cloud.parser.standard.StringParser;

@API(status=API.Status.INTERNAL)
public final class ComponentParserContributor
implements ParserContributor {
    public <C> void contribute(ParserRegistry<C> registry) {
        try {
            registry.registerAnnotationMapper(Decoder.MiniMessage.class, (annotation, parsedType) -> ParserParameters.single(MinecraftExtrasParserParameters.COMPONENT_DECODER, arg_0 -> ((MiniMessage)MiniMessage.miniMessage()).deserialize(arg_0)));
            registry.registerAnnotationMapper(Decoder.Legacy.class, (annotation, parsedType) -> {
                char character = annotation.value();
                return ParserParameters.single(MinecraftExtrasParserParameters.COMPONENT_DECODER, string -> LegacyComponentSerializer.legacy(character).deserialize((String)string));
            });
            registry.registerAnnotationMapper(Decoder.Json.class, (annotation, parsedType) -> {
                boolean downsampleColors = annotation.downsampleColors();
                Function<String, Component> decoder = downsampleColors ? arg_0 -> ((GsonComponentSerializer)GsonComponentSerializer.colorDownsamplingGson()).deserialize(arg_0) : arg_0 -> ((GsonComponentSerializer)GsonComponentSerializer.gson()).deserialize(arg_0);
                return ParserParameters.single(MinecraftExtrasParserParameters.COMPONENT_DECODER, decoder);
            });
            registry.registerAnnotationMapper(Decoder.class, (annotation, parsedType) -> {
                Function<String, ? extends Component> decoder;
                try {
                    decoder = annotation.value().getConstructor(new Class[0]).newInstance(new Object[0]).decoder(parsedType);
                }
                catch (ReflectiveOperationException exception) {
                    throw new IllegalArgumentException("Could not create decoder for " + annotation.value(), exception);
                }
                return ParserParameters.single(MinecraftExtrasParserParameters.COMPONENT_DECODER, decoder);
            });
            registry.registerParserSupplier(TypeToken.get(Component.class), options -> {
                boolean greedy = (Boolean)options.get(StandardParameters.GREEDY, (Object)false);
                boolean greedyFlagAware = (Boolean)options.get(StandardParameters.FLAG_YIELDING, (Object)false);
                boolean quoted = (Boolean)options.get(StandardParameters.QUOTED, (Object)false);
                if (greedyFlagAware && quoted) {
                    throw new IllegalArgumentException("Don't know whether to create GREEDY_FLAG_YIELDING or QUOTED StringArgument.StringParser, both specified.");
                }
                if (greedy && quoted) {
                    throw new IllegalArgumentException("Don't know whether to create GREEDY or QUOTED StringArgument.StringParser, both specified.");
                }
                StringParser.StringMode stringMode = greedyFlagAware ? StringParser.StringMode.GREEDY_FLAG_YIELDING : (greedy ? StringParser.StringMode.GREEDY : (quoted ? StringParser.StringMode.QUOTED : StringParser.StringMode.SINGLE));
                Function decoder = (Function)options.get(MinecraftExtrasParserParameters.COMPONENT_DECODER, arg_0 -> ((MiniMessage)MiniMessage.miniMessage()).deserialize(arg_0));
                return new ComponentParser(decoder, stringMode);
            });
        }
        catch (Exception | LinkageError throwable) {
            // empty catch block
        }
    }
}

