/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric;

import dev.qixils.crowdcontrol.TriState;
import dev.qixils.crowdcontrol.common.EntityMapper;
import dev.qixils.crowdcontrol.common.PlayerEntityMapper;
import dev.qixils.crowdcontrol.common.PlayerManager;
import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.common.mc.MCCCPlayer;
import dev.qixils.crowdcontrol.common.packets.util.ExtraFeature;
import dev.qixils.crowdcontrol.common.util.SemVer;
import dev.qixils.crowdcontrol.plugin.configurate.ConfiguratePlugin;
import dev.qixils.crowdcontrol.plugin.fabric.CommandRegister;
import dev.qixils.crowdcontrol.plugin.fabric.CommandSourceStackMapper;
import dev.qixils.crowdcontrol.plugin.fabric.MinecraftEvents;
import dev.qixils.crowdcontrol.plugin.fabric.MojmapPlayerManager;
import dev.qixils.crowdcontrol.plugin.fabric.ServerPlayerMapper;
import dev.qixils.crowdcontrol.plugin.fabric.SoftLockResolver;
import dev.qixils.crowdcontrol.plugin.fabric.event.EventManager;
import dev.qixils.crowdcontrol.plugin.fabric.event.Join;
import dev.qixils.crowdcontrol.plugin.fabric.event.Leave;
import dev.qixils.crowdcontrol.plugin.fabric.mc.FabricPlayer;
import dev.qixils.crowdcontrol.plugin.fabric.packets.ExtraFeatureC2S;
import dev.qixils.crowdcontrol.plugin.fabric.packets.RequestVersionS2C;
import dev.qixils.crowdcontrol.plugin.fabric.packets.ResponseVersionC2S;
import dev.qixils.crowdcontrol.plugin.fabric.packets.ServerPacketContext;
import dev.qixils.crowdcontrol.plugin.fabric.utils.ClientAdapter;
import dev.qixils.crowdcontrol.plugin.fabric.utils.MojmapTextUtil;
import dev.qixils.crowdcontrol.plugin.fabric.utils.PermissionUtil;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import dev.qixils.relocated.checkerframework.checker.nullness.qual.MonotonicNonNull;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import lombok.Generated;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.platform.modcommon.MinecraftServerAudiences;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.Component;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.flag.FeatureElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;

public abstract class ModdedCrowdControlPlugin
extends ConfiguratePlugin<ServerPlayer, CommandSourceStack> {
    public static boolean CLIENT_INITIALIZED = false;
    public static boolean CLIENT_AVAILABLE = false;
    @NotNull
    private final EventManager eventManager = new EventManager();
    private final CommandRegister commandRegister = new CommandRegister(this);
    @Nullable
    protected MinecraftServer server;
    @Nullable
    protected MinecraftServerAudiences adventure;
    @NotNull
    private MojmapTextUtil textUtil = new MojmapTextUtil(this);
    @NotNull
    private Executor syncExecutor = runnable -> {
        try {
            if (this.server != null) {
                this.server.executeIfPossible(runnable);
            } else {
                runnable.run();
            }
        }
        catch (Exception e) {
            this.getSLF4JLogger().error("Error while executing sync task", (Throwable)e);
        }
    };
    private final ExecutorService asyncExecutor = Executors.newCachedThreadPool();
    private final Logger SLF4JLogger = LoggerFactory.getLogger((String)"CrowdControl");
    private final PlayerManager<ServerPlayer> playerManager = new MojmapPlayerManager(this);
    private final PlayerEntityMapper<ServerPlayer> playerMapper = new ServerPlayerMapper(this);
    private final EntityMapper<CommandSourceStack> commandSenderMapper = new CommandSourceStackMapper(this);
    private final SoftLockResolver softLockResolver = new SoftLockResolver(this);
    @NotNull
    private final HoconConfigurationLoader configLoader = this.createConfigLoader(Path.of("config", new String[0]));
    private static @MonotonicNonNull ModdedCrowdControlPlugin instance;
    private boolean paused = false;

    public ModdedCrowdControlPlugin() {
        super(ServerPlayer.class, CommandSourceStack.class);
        CommandConstants.SOUND_VALIDATOR = key -> BuiltInRegistries.SOUND_EVENT.containsKey(ResourceLocation.fromNamespaceAndPath((String)key.namespace(), (String)key.value()));
        instance = this;
        this.getEventManager().registerListeners(this.softLockResolver);
        this.getEventManager().register(Join.class, join -> this.onPlayerJoin(join.player()));
        this.getEventManager().register(Leave.class, leave -> this.onPlayerLeave(leave.player()));
    }

    public void onInitialize() {
        this.getSLF4JLogger().debug("Initializing");
        this.registerChatCommands();
        MinecraftEvents.SERVER_STARTING.register(newServer -> {
            this.getSLF4JLogger().debug("Server starting");
            this.setServer((MinecraftServer)newServer);
        });
        MinecraftEvents.SERVER_STOPPING.register($ -> this.shutdown());
        MinecraftEvents.SERVER_STOPPED.register(newServer -> {
            this.getSLF4JLogger().debug("Server stopping");
            this.setServer(null);
        });
    }

    public <T> Registry<T> registry(ResourceKey<? extends Registry<? extends T>> key, @Nullable RegistryAccess accessor) {
        if (accessor == null) {
            accessor = this.server().registryAccess();
        }
        return accessor.lookupOrThrow(key);
    }

    public <T> Iterable<Holder.Reference<T>> registryHolders(ResourceKey<? extends Registry<? extends T>> key, @Nullable RegistryAccess accessor) {
        final Registry<T> registry = this.registry(key, accessor);
        return new Iterable<Holder.Reference<T>>(this){

            @Override
            @NotNull
            public Iterator<Holder.Reference<T>> iterator() {
                return registry.listElements().iterator();
            }
        };
    }

    @Override
    @NotNull
    public MCCCPlayer getPlayer(@NotNull ServerPlayer player) {
        return new FabricPlayer(player);
    }

    @NotNull
    public static ModdedCrowdControlPlugin getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Plugin instance not initialized");
        }
        return instance;
    }

    public static boolean isInstanceAvailable() {
        return instance != null;
    }

    @Override
    @NotNull
    public Collection<String> getHosts() {
        HashSet<String> hosts = new HashSet<String>(super.getHosts());
        ClientAdapter.getLocalPlayerId().map(UUID::toString).ifPresent(hosts::add);
        return hosts;
    }

    @NotNull
    public MinecraftServer server() throws IllegalStateException {
        if (this.server == null) {
            throw new IllegalStateException("Tried to access server without one running");
        }
        return this.server;
    }

    @NotNull
    public MinecraftServerAudiences adventure() throws IllegalStateException {
        if (this.adventure == null) {
            throw new IllegalStateException("Tried to access Adventure without running a server");
        }
        return this.adventure;
    }

    @NotNull
    public Optional<MinecraftServerAudiences> adventureOptional() {
        return Optional.ofNullable(this.adventure);
    }

    protected void setServer(@Nullable MinecraftServer server) {
        if (server == null) {
            this.server = null;
            this.adventure = null;
            this.syncExecutor = Runnable::run;
        } else {
            this.server = server;
            this.adventure = MinecraftServerAudiences.of((MinecraftServer)server);
            this.syncExecutor = server;
            this.textUtil = new MojmapTextUtil(this);
            this.initCrowdControl();
        }
    }

    @Override
    public CompletableFuture<?> shutdown() {
        CompletableFuture<?> superShutdown = super.shutdown();
        this.asyncExecutor.shutdown();
        return CompletableFuture.allOf(superShutdown, CompletableFuture.supplyAsync(() -> {
            try {
                return this.asyncExecutor.awaitTermination(3L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    @Override
    @NotNull
    public Audience getConsole() {
        return this.adventure().console();
    }

    @Override
    public void onPlayerJoin(ServerPlayer player) {
        ClientAdapter.getLocalPlayerId().ifPresent(uuid -> this.clientVersions.put(uuid, SemVer.MOD));
        if (!this.clientVersions.containsKey(player.getUUID())) {
            this.getSLF4JLogger().debug("Sending version request to {}", (Object)player.getUUID());
            this.sendToPlayer(player, RequestVersionS2C.INSTANCE);
        }
        super.onPlayerJoin(player);
    }

    @Override
    @Nullable
    public ServerPlayer asPlayer(@NotNull CommandSourceStack sender) {
        return sender.getPlayer();
    }

    @NotNull
    public TriState isEnabled(FeatureElement feature) {
        if (this.server == null) {
            return TriState.UNKNOWN;
        }
        return TriState.fromBoolean(feature.isEnabled(this.server.getWorldData().enabledFeatures()));
    }

    public boolean isDisabled(FeatureElement feature) {
        return this.isEnabled(feature) == TriState.FALSE;
    }

    @NotNull
    public Component toAdventure(net.minecraft.network.chat.Component vanilla) {
        return this.adventure().asAdventure(vanilla);
    }

    @NotNull
    public Component toAdventure(Component text, @NotNull Pointered viewer) {
        return this.adventure().renderer().render(text, (Object)viewer);
    }

    @NotNull
    public Component toAdventure(net.minecraft.network.chat.Component vanilla, @NotNull Pointered viewer) {
        return this.toAdventure(this.toAdventure(vanilla), viewer);
    }

    @NotNull
    public net.minecraft.network.chat.Component toNative(Component text, @NotNull Pointered viewer) {
        return this.adventure().asNative(this.toAdventure(text, viewer));
    }

    public abstract PermissionUtil getPermissionUtil();

    @NotNull
    public Stream<ServerPlayer> toPlayerStream(@Nullable Collection<UUID> uuids) {
        MinecraftServer _server = this.server;
        if (uuids == null || _server == null) {
            return Stream.empty();
        }
        return uuids.stream().map(id -> _server.getPlayerList().getPlayer(id)).filter(Objects::nonNull);
    }

    @NotNull
    public List<ServerPlayer> toPlayerList(@Nullable Collection<UUID> uuids) {
        return this.toPlayerStream(uuids).toList();
    }

    public void handleVersionResponse(ResponseVersionC2S payload, ServerPacketContext context) {
        UUID uuid = context.player().getUUID();
        SemVer version = payload.version();
        this.getSLF4JLogger().info("Received version {} from client {}", (Object)version, (Object)uuid);
        this.clientVersions.put(uuid, version);
        this.updateConditionalEffectVisibility(uuid);
    }

    public void handleExtraFeatures(ExtraFeatureC2S payload, ServerPacketContext context) {
        UUID uuid = context.player().getUUID();
        Set<ExtraFeature> features = payload.features();
        this.getSLF4JLogger().info("Received features {} from client {}", features, (Object)uuid);
        this.extraFeatures.put(uuid, features);
        this.updateConditionalEffectVisibility(uuid);
    }

    public abstract void sendToPlayer(@NotNull ServerPlayer var1, @NotNull CustomPacketPayload var2);

    public static void sendToPlayerStatic(@NotNull ServerPlayer player, @NotNull CustomPacketPayload payload) {
        if (!ModdedCrowdControlPlugin.isInstanceAvailable()) {
            return;
        }
        ModdedCrowdControlPlugin.getInstance().sendToPlayer(player, payload);
    }

    @NotNull
    @Generated
    public EventManager getEventManager() {
        return this.eventManager;
    }

    @Generated
    public CommandRegister commandRegister() {
        return this.commandRegister;
    }

    @Nullable
    @Generated
    public MinecraftServer getServer() {
        return this.server;
    }

    @Override
    @NotNull
    @Generated
    public MojmapTextUtil getTextUtil() {
        return this.textUtil;
    }

    @Override
    @NotNull
    @Generated
    public Executor getSyncExecutor() {
        return this.syncExecutor;
    }

    @Override
    @Generated
    public ExecutorService getAsyncExecutor() {
        return this.asyncExecutor;
    }

    @Override
    @Generated
    public Logger getSLF4JLogger() {
        return this.SLF4JLogger;
    }

    @Override
    @Generated
    public PlayerManager<ServerPlayer> getPlayerManager() {
        return this.playerManager;
    }

    @Override
    @Generated
    public PlayerEntityMapper<ServerPlayer> playerMapper() {
        return this.playerMapper;
    }

    @Override
    @Generated
    public EntityMapper<CommandSourceStack> commandSenderMapper() {
        return this.commandSenderMapper;
    }

    @Generated
    public SoftLockResolver getSoftLockResolver() {
        return this.softLockResolver;
    }

    @NotNull
    @Generated
    public HoconConfigurationLoader getConfigLoader() {
        return this.configLoader;
    }

    @Override
    @Generated
    public boolean isPaused() {
        return this.paused;
    }

    @Generated
    public void setPaused(boolean paused) {
        this.paused = paused;
    }
}

