/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric;

import dev.qixils.crowdcontrol.common.LoginData;
import dev.qixils.crowdcontrol.common.PlayerEntityMapper;
import dev.qixils.crowdcontrol.common.util.PermissionWrapper;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.relocated.annotations.NotNull;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import net.kyori.adventure.audience.Audience;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class ServerPlayerMapper
implements PlayerEntityMapper<ServerPlayer> {
    protected final ModdedCrowdControlPlugin plugin;

    @Override
    @NotNull
    public Audience asAudience(@NotNull ServerPlayer entity) {
        return entity;
    }

    @Override
    @NotNull
    public Optional<UUID> tryGetUniqueId(@NotNull ServerPlayer entity) {
        return Optional.of(entity.getUUID());
    }

    @Override
    @NotNull
    public UUID getUniqueId(@NotNull ServerPlayer entity) {
        return entity.getUUID();
    }

    @Override
    public boolean hasPermission(@NotNull ServerPlayer entity, @NotNull PermissionWrapper perm) {
        return this.plugin.getPermissionUtil().check((Entity)entity, perm);
    }

    @Override
    @NotNull
    public String getUsername(@NotNull ServerPlayer player) {
        return player.getGameProfile().getName();
    }

    @Override
    @NotNull
    public Optional<ServerPlayer> getPlayer(@NotNull UUID uuid) {
        return Optional.ofNullable(this.plugin.getServer()).map(server -> server.getPlayerList().getPlayer(uuid));
    }

    @Override
    @NotNull
    public Optional<ServerPlayer> getPlayer(@NotNull InetAddress ip) {
        return Optional.ofNullable(this.plugin.getServer()).map(server -> {
            ServerPlayer result = null;
            for (ServerPlayer player : server.getPlayerList().getPlayers()) {
                InetSocketAddress inetAddress;
                SocketAddress address;
                if (player.connection == null || !((address = player.connection.getRemoteAddress()) instanceof InetSocketAddress) || !Objects.equals((inetAddress = (InetSocketAddress)address).getAddress(), ip)) continue;
                if (result != null) {
                    return null;
                }
                result = player;
            }
            return result;
        });
    }

    @Override
    @NotNull
    public Optional<ServerPlayer> getPlayerByLogin(@NotNull LoginData login) {
        return Optional.ofNullable(this.plugin.getServer()).flatMap(server -> {
            for (ServerPlayer player : server.getPlayerList().getPlayers()) {
                if (!player.getGameProfile().getName().equalsIgnoreCase(login.getName()) && !player.getUUID().equals(login.getId())) continue;
                return Optional.of(player);
            }
            return Optional.empty();
        });
    }

    @Override
    @NotNull
    public Optional<InetAddress> getIP(@NotNull ServerPlayer player) {
        return Optional.ofNullable(player.connection).map(connection -> {
            SocketAddress address = connection.getRemoteAddress();
            if (address instanceof InetSocketAddress) {
                InetSocketAddress inetAddress = (InetSocketAddress)address;
                return inetAddress.getAddress();
            }
            return null;
        });
    }

    @Generated
    public ModdedCrowdControlPlugin getPlugin() {
        return this.plugin;
    }

    @Generated
    public ServerPlayerMapper(ModdedCrowdControlPlugin plugin) {
        this.plugin = plugin;
    }
}

