/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import com.mojang.datafixers.util.Pair;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.commands.NearbyLocationCommand;
import dev.qixils.crowdcontrol.plugin.fabric.utils.Location;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;

public class BiomeCommand
extends NearbyLocationCommand<ResourceKey<Biome>> {
    private static final Map<ResourceKey<Level>, List<ResourceKey<Biome>>> BIOMES = Map.of(Level.OVERWORLD, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.DESERT, Biomes.SWAMP, Biomes.MANGROVE_SWAMP, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.BIRCH_FOREST, Biomes.DARK_FOREST, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.WINDSWEPT_SAVANNA, Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.BAMBOO_JUNGLE, Biomes.BADLANDS, Biomes.ERODED_BADLANDS, Biomes.WOODED_BADLANDS, Biomes.MEADOW, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.RIVER, Biomes.FROZEN_RIVER, Biomes.BEACH, Biomes.SNOWY_BEACH, Biomes.STONY_SHORE, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.DEEP_COLD_OCEAN, Biomes.DEEP_FROZEN_OCEAN, Biomes.OCEAN, Biomes.FROZEN_OCEAN, Biomes.DEEP_OCEAN, Biomes.MUSHROOM_FIELDS), Level.NETHER, List.of(Biomes.NETHER_WASTES, Biomes.SOUL_SAND_VALLEY, Biomes.CRIMSON_FOREST, Biomes.WARPED_FOREST, Biomes.BASALT_DELTAS), Level.END, List.of(Biomes.THE_END, Biomes.SMALL_END_ISLANDS, Biomes.END_MIDLANDS, Biomes.END_HIGHLANDS, Biomes.END_BARRENS));
    private final String effectName = "biome";

    public BiomeCommand(ModdedCrowdControlPlugin plugin) {
        super(plugin);
    }

    @Override
    @Nullable
    protected Location search(@NotNull Location origin, @NotNull ResourceKey<Biome> searchType) {
        Pair pair = origin.level().findClosestBiome3d(biome -> biome.is(searchType), origin.pos(), 512, 32, 32);
        if (pair == null) {
            return null;
        }
        return new Location(origin.level(), (BlockPos)pair.getFirst());
    }

    @Override
    @NotNull
    protected Collection<ResourceKey<Biome>> getSearchTypes(@NotNull ServerLevel level) {
        return BIOMES.get(level.dimension());
    }

    @Override
    @NotNull
    protected Component nameOf(@NotNull ResourceKey<Biome> searchType) {
        ResourceLocation id = searchType.location();
        return Component.translatable((String)("biome." + id.getNamespace() + "." + id.getPath()));
    }

    @Override
    @Nullable
    protected ResourceKey<Biome> currentType(@NotNull Location origin) {
        return origin.level().getBiome(origin.pos()).unwrapKey().orElse(null);
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }
}

