/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.relocated.annotations.NotNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class DeleteRandomItemCommand
extends ModdedCommand {
    private final String effectName = "delete_random_item";

    public DeleteRandomItemCommand(ModdedCrowdControlPlugin plugin) {
        super(plugin);
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            boolean success = false;
            for (ServerPlayer player : (List)playerSupplier.get()) {
                Inventory inv = player.getInventory();
                if (inv.isEmpty()) continue;
                success = true;
                List indices = IntStream.range(0, inv.getContainerSize()).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
                Collections.shuffle(indices);
                this.sync(() -> {
                    Iterator iterator = indices.iterator();
                    while (iterator.hasNext()) {
                        int i = (Integer)iterator.next();
                        ItemStack stack = inv.getItem(i);
                        if (stack.isEmpty()) continue;
                        inv.setItem(i, ItemStack.EMPTY);
                        break;
                    }
                });
            }
            return success ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "No players have items");
        }));
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }
}

