/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;

public class DinnerboneCommand
extends ModdedCommand {
    private static final Component DINNERBONE_COMPONENT = Component.literal((String)"Dinnerbone");
    private final String effectName = "dinnerbone";

    public DinnerboneCommand(ModdedCrowdControlPlugin plugin) {
        super(plugin);
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            HashSet<LivingEntity> entities = new HashSet<LivingEntity>();
            for (ServerPlayer player : (List)playerSupplier.get()) {
                entities.addAll(StreamSupport.stream(player.level().getAllEntities().spliterator(), false).filter(entity -> entity instanceof LivingEntity && entity.getType() != EntityType.PLAYER && entity.position().distanceToSqr(player.position()) <= 900.0).map(entity -> (LivingEntity)entity).toList());
            }
            if (entities.isEmpty()) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "No nearby entities");
            }
            for (LivingEntity entity2 : entities) {
                @Nullable Component oldName = entity2.cc$getOriginalDisplayName();
                @Nullable Component currentName = entity2.getCustomName();
                if (Objects.equals(currentName, DINNERBONE_COMPONENT)) {
                    entity2.setCustomName(oldName);
                    entity2.cc$setOriginalDisplayName(null);
                    if (!entity2.cc$isViewerSpawned()) continue;
                    entity2.setCustomNameVisible(true);
                    continue;
                }
                entity2.cc$setOriginalDisplayName(currentName);
                entity2.setCustomName((Component)DINNERBONE_COMPONENT.copy());
                entity2.setCustomNameVisible(false);
            }
            return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS);
        }, this.plugin.getSyncExecutor()));
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }
}

