/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.relocated.annotations.NotNull;
import java.util.List;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import net.minecraft.server.level.ServerPlayer;

public class DropItemCommand
extends ModdedCommand {
    private final String effectName = "drop_item";

    public DropItemCommand(@NotNull ModdedCrowdControlPlugin plugin) {
        super(plugin);
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            boolean success = false;
            for (ServerPlayer player : (List)playerSupplier.get()) {
                if (player.getInventory().getSelectedItem().isEmpty()) continue;
                this.sync(() -> {
                    player.drop(true);
                    player.containerMenu.sendAllDataToRemote();
                });
                success = true;
            }
            return success ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "No players were holding items");
        }));
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }
}

