/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.relocated.annotations.NotNull;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.CCName;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class EnchantmentCommand
extends ModdedCommand {
    protected final Holder<Enchantment> enchantmentHolder;
    protected final Enchantment enchantment;
    private final String effectName;
    private final net.kyori.adventure.text.Component displayName;
    private final CCName extensionName;
    private final String image = "enchant_sharpness";
    private final int price = 50;
    private final byte priority = 0;
    private final List<String> categories = Collections.singletonList("Enchantments");

    public EnchantmentCommand(ModdedCrowdControlPlugin plugin, Holder<Enchantment> enchantment) {
        super(plugin);
        this.enchantmentHolder = enchantment;
        this.enchantment = (Enchantment)this.enchantmentHolder.value();
        this.effectName = "enchant_" + CommandConstants.csIdOf((Keyed)enchantment.unwrapKey().orElseThrow());
        TranslatableComponent _displayName = net.kyori.adventure.text.Component.translatable((String)"cc.effect.enchant.name", (ComponentLike[])new ComponentLike[]{plugin.toAdventure((Component)Enchantment.getFullname(enchantment, (int)((Enchantment)enchantment.value()).getMaxLevel()).copy().setStyle(Style.EMPTY))});
        this.displayName = _displayName;
        this.extensionName = new CCName(plugin.getTextUtil().asPlain((ComponentLike)_displayName.key("cc.effect.enchant.extension")));
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            boolean success = false;
            for (ServerPlayer player : (List)playerSupplier.get()) {
                int level = this.enchantment.getMaxLevel();
                Inventory inv = player.getInventory();
                HashMap<EquipmentSlot, Integer> levelMap = new HashMap<EquipmentSlot, Integer>(EquipmentSlot.values().length);
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    ItemStack item = EnchantmentCommand.getItem(inv, slot);
                    if (item.isEmpty() || !this.enchantment.canEnchant(item) || this.enchantment.getMaxLevel() == this.enchantment.getMinLevel() && (EnchantmentCommand.getEnchantmentLevel(item, this.enchantmentHolder) == this.enchantment.getMaxLevel() || EnchantmentCommand.getEnchantmentLevel(item, this.enchantmentHolder) == 255)) continue;
                    levelMap.put(slot, EnchantmentCommand.getEnchantmentLevel(item, this.enchantmentHolder));
                }
                EquipmentSlot slot = levelMap.entrySet().stream().min(Comparator.comparingInt(Map.Entry::getValue)).map(Map.Entry::getKey).orElse(null);
                if (slot == null) continue;
                ItemStack item = EnchantmentCommand.getItem(inv, slot);
                int curLevel = EnchantmentCommand.getEnchantmentLevel(item, this.enchantmentHolder);
                if (curLevel >= level) {
                    level = curLevel + 1;
                }
                int setLevel = level;
                EnchantmentHelper.updateEnchantments((ItemStack)item, mutable -> mutable.set(this.enchantmentHolder, setLevel));
                success = true;
            }
            return success ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "No items could be enchanted");
        }));
    }

    public static ItemStack getItem(Inventory inv, EquipmentSlot slot) {
        if (slot == EquipmentSlot.MAINHAND) {
            return inv.getSelectedItem();
        }
        return inv.getItem(slot.getIndex(36));
    }

    public static int getEnchantmentLevel(ItemStack item, Holder<Enchantment> enchantment) {
        return EnchantmentHelper.getItemEnchantmentLevel(enchantment, (ItemStack)item);
    }

    @Generated
    public Holder<Enchantment> getEnchantmentHolder() {
        return this.enchantmentHolder;
    }

    @Generated
    public Enchantment getEnchantment() {
        return this.enchantment;
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }

    @Override
    @Generated
    public net.kyori.adventure.text.Component getDisplayName() {
        return this.displayName;
    }

    @Override
    @Generated
    public CCName getExtensionName() {
        return this.extensionName;
    }

    @Override
    @Generated
    public String getImage() {
        return this.image;
    }

    @Override
    @Generated
    public int getPrice() {
        return this.price;
    }

    @Override
    @Generated
    public byte getPriority() {
        return this.priority;
    }

    @Override
    @Generated
    public List<String> getCategories() {
        return this.categories;
    }
}

