/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.LimitConfig;
import dev.qixils.crowdcontrol.common.command.QuantityStyle;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.commands.ItemCommand;
import dev.qixils.relocated.annotations.Blocking;
import dev.qixils.relocated.annotations.NotNull;
import java.util.List;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class GiveItemCommand
extends ModdedCommand
implements ItemCommand {
    @NotNull
    private final QuantityStyle quantityStyle = QuantityStyle.APPEND_X;
    private final Item item;
    private final String effectName;
    private final TranslatableComponent defaultDisplayName;

    public GiveItemCommand(ModdedCrowdControlPlugin plugin, Item item) {
        super(plugin);
        this.item = item;
        this.effectName = "give_" + BuiltInRegistries.ITEM.getKey((Object)item).getPath();
        this.defaultDisplayName = Component.translatable((String)"cc.effect.give_item.name", (ComponentLike[])new ComponentLike[]{plugin.toAdventure(item.getName(new ItemStack((ItemLike)item)))});
    }

    @Blocking
    public static void giveItemTo(ServerPlayer player, ItemStack itemStack) {
        ItemEntity entity = player.spawnAtLocation(player.level(), itemStack);
        if (entity == null) {
            throw new IllegalStateException("Could not spawn item entity");
        }
        entity.setTarget(player.getUUID());
        entity.setThrower((Entity)player);
        entity.setPickUpDelay(0);
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            List players = (List)playerSupplier.get();
            LimitConfig config = this.getPlugin().getLimitConfig();
            int playerLimit = config.getItemLimit(BuiltInRegistries.ITEM.getKey((Object)this.item).getPath());
            int amount = request.getQuantity();
            ItemStack itemStack = new ItemStack((ItemLike)this.item, amount);
            return this.executeLimit(request, players, playerLimit, player -> {
                this.sync(() -> GiveItemCommand.giveItemTo(player, itemStack));
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS);
            });
        }));
    }

    @Override
    @NotNull
    @Generated
    public QuantityStyle getQuantityStyle() {
        return this.quantityStyle;
    }

    @Override
    @Generated
    public Item getItem() {
        return this.item;
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }

    @Override
    @Generated
    public TranslatableComponent getDefaultDisplayName() {
        return this.defaultDisplayName;
    }
}

