/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.utils.AttributeUtil;
import dev.qixils.relocated.annotations.NotNull;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.CCTimedEffect;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCTimedEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class GravityCommand
extends ModdedCommand
implements CCTimedEffect {
    private final String effectName;
    private final double gravityLevel;
    private final double fallLevel;
    private final double fallDmgLevel;
    private final List<String> effectGroups = Arrays.asList("gravity", "walk");
    private final Map<UUID, List<UUID>> idMap = new HashMap<UUID, List<UUID>>();

    private GravityCommand(ModdedCrowdControlPlugin plugin, String effectName, double gravityLevel, double fallLevel, double fallDmgLevel) {
        super(plugin);
        this.effectName = effectName;
        this.gravityLevel = gravityLevel;
        this.fallLevel = fallLevel;
        this.fallDmgLevel = fallDmgLevel;
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            if (this.isActive(ccPlayer, this.getEffectArray())) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Cannot change gravity while frozen");
            }
            List players = (List)playerSupplier.get();
            this.idMap.put(request.getRequestId(), players.stream().map(Entity::getUUID).toList());
            for (ServerPlayer player : players) {
                AttributeUtil.addModifier((LivingEntity)player, (Holder<Attribute>)Attributes.GRAVITY, CommandConstants.GRAVITY_MODIFIER_UUID, this.gravityLevel, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, false);
                AttributeUtil.addModifier((LivingEntity)player, (Holder<Attribute>)Attributes.SAFE_FALL_DISTANCE, CommandConstants.FALL_MODIFIER_UUID, this.fallLevel, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, false);
                AttributeUtil.addModifier((LivingEntity)player, (Holder<Attribute>)Attributes.FALL_DAMAGE_MULTIPLIER, CommandConstants.FALL_DMG_MODIFIER_UUID, this.fallDmgLevel, AttributeModifier.Operation.ADD_VALUE, false);
            }
            return new CCTimedEffectResponse(request.getRequestId(), ResponseStatus.TIMED_BEGIN, request.getEffect().getDurationMillis());
        }));
    }

    @Override
    public void onEnd(@NotNull PublicEffectPayload request, @NotNull CCPlayer source) {
        for (ServerPlayer player : this.plugin.toPlayerList((Collection<UUID>)this.idMap.remove(request.getRequestId()))) {
            AttributeUtil.removeModifier((LivingEntity)player, (Holder<Attribute>)Attributes.GRAVITY, CommandConstants.GRAVITY_MODIFIER_UUID);
            AttributeUtil.removeModifier((LivingEntity)player, (Holder<Attribute>)Attributes.SAFE_FALL_DISTANCE, CommandConstants.FALL_MODIFIER_UUID);
        }
    }

    @NotNull
    public static GravityCommand zero(ModdedCrowdControlPlugin plugin) {
        return new GravityCommand(plugin, "zero_gravity", -1.0, 0.0, 0.0);
    }

    @NotNull
    public static GravityCommand low(ModdedCrowdControlPlugin plugin) {
        return new GravityCommand(plugin, "low_gravity", -0.5, 1.0, -0.5);
    }

    @NotNull
    public static GravityCommand high(ModdedCrowdControlPlugin plugin) {
        return new GravityCommand(plugin, "high_gravity", 1.0, -0.5, 1.0);
    }

    @NotNull
    public static GravityCommand maximum(ModdedCrowdControlPlugin plugin) {
        return new GravityCommand(plugin, "maximum_gravity", 3.0, -1.0, 3.0);
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }

    @Generated
    public double getGravityLevel() {
        return this.gravityLevel;
    }

    @Generated
    public double getFallLevel() {
        return this.fallLevel;
    }

    @Generated
    public double getFallDmgLevel() {
        return this.fallDmgLevel;
    }

    @Override
    @Generated
    public List<String> getEffectGroups() {
        return this.effectGroups;
    }

    @Generated
    public Map<UUID, List<UUID>> getIdMap() {
        return this.idMap;
    }
}

