/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.utils.AttributeUtil;
import dev.qixils.relocated.annotations.NotNull;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.CCTimedEffect;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCTimedEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class PlayerSizeCommand
extends ModdedCommand
implements CCTimedEffect {
    private final Map<UUID, Set<UUID>> idMap = new HashMap<UUID, Set<UUID>>();
    private final String effectName;
    private final double level;
    private final String effectGroup = "gravity";
    private final List<String> effectGroups = Collections.singletonList("gravity");

    public PlayerSizeCommand(ModdedCrowdControlPlugin plugin, String effectName, double level) {
        super(plugin);
        this.effectName = effectName;
        this.level = level;
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            if (this.isArrayActive(ccPlayer)) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Conflicting effects active");
            }
            List players = (List)playerSupplier.get();
            this.idMap.put(request.getRequestId(), players.stream().map(Entity::getUUID).collect(Collectors.toSet()));
            for (ServerPlayer player : players) {
                AttributeUtil.addModifier((LivingEntity)player, (Holder<Attribute>)Attributes.SCALE, CommandConstants.SCALE_MODIFIER_UUID, this.level, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, false);
                AttributeUtil.addModifier((LivingEntity)player, (Holder<Attribute>)Attributes.STEP_HEIGHT, CommandConstants.SCALE_STEP_MODIFIER_UUID, this.level, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, false);
                AttributeUtil.addModifier((LivingEntity)player, (Holder<Attribute>)Attributes.JUMP_STRENGTH, CommandConstants.SCALE_JUMP_MODIFIER_UUID, this.level, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, false);
                AttributeUtil.addModifier((LivingEntity)player, (Holder<Attribute>)Attributes.SAFE_FALL_DISTANCE, CommandConstants.FALL_MODIFIER_UUID, this.level, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, false);
            }
            return new CCTimedEffectResponse(request.getRequestId(), ResponseStatus.TIMED_BEGIN, request.getEffect().getDurationMillis());
        }));
    }

    @Override
    public void onEnd(@NotNull PublicEffectPayload request, @NotNull CCPlayer source) {
        this.plugin.toPlayerStream((Collection<UUID>)this.idMap.remove(request.getRequestId())).forEach(player -> {
            AttributeUtil.removeModifier((LivingEntity)player, (Holder<Attribute>)Attributes.SCALE, CommandConstants.SCALE_MODIFIER_UUID);
            AttributeUtil.removeModifier((LivingEntity)player, (Holder<Attribute>)Attributes.STEP_HEIGHT, CommandConstants.SCALE_STEP_MODIFIER_UUID);
            AttributeUtil.removeModifier((LivingEntity)player, (Holder<Attribute>)Attributes.JUMP_STRENGTH, CommandConstants.SCALE_JUMP_MODIFIER_UUID);
            AttributeUtil.removeModifier((LivingEntity)player, (Holder<Attribute>)Attributes.SAFE_FALL_DISTANCE, CommandConstants.FALL_MODIFIER_UUID);
        });
    }

    public static PlayerSizeCommand increase(ModdedCrowdControlPlugin plugin) {
        return new PlayerSizeCommand(plugin, "player_size_double", 1.0);
    }

    public static PlayerSizeCommand decrease(ModdedCrowdControlPlugin plugin) {
        return new PlayerSizeCommand(plugin, "player_size_halve", -0.5);
    }

    @Generated
    public Map<UUID, Set<UUID>> getIdMap() {
        return this.idMap;
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }

    @Generated
    public double getLevel() {
        return this.level;
    }

    @Generated
    public String getEffectGroup() {
        return this.effectGroup;
    }

    @Override
    @Generated
    public List<String> getEffectGroups() {
        return this.effectGroups;
    }
}

