/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.Global;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.relocated.annotations.NotNull;
import java.util.List;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

@Global
public class SetTimeCommand
extends ModdedCommand {
    @NotNull
    private final String effectName;
    private final long time;

    public SetTimeCommand(ModdedCrowdControlPlugin plugin, @NotNull String effectName, long time) {
        super(plugin);
        this.effectName = effectName;
        this.time = time;
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            playerSupplier.get();
            for (ServerLevel level : this.plugin.server().getAllLevels()) {
                long ogTime = level.getDayTime();
                long setTime = ogTime - ogTime % 24000L + this.time;
                this.sync(() -> level.setDayTime(setTime));
            }
            return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS);
        }));
    }

    @NotNull
    public static SetTimeCommand day(ModdedCrowdControlPlugin plugin) {
        return new SetTimeCommand(plugin, "time_day", 1000L);
    }

    @NotNull
    public static SetTimeCommand night(ModdedCrowdControlPlugin plugin) {
        return new SetTimeCommand(plugin, "time_night", 13000L);
    }

    @Override
    @NotNull
    @Generated
    public String getEffectName() {
        return this.effectName;
    }

    @Generated
    public long getTime() {
        return this.time;
    }
}

