/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.LimitConfig;
import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.common.util.RandomUtil;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.commands.EntityCommand;
import dev.qixils.crowdcontrol.plugin.fabric.commands.LootboxCommand;
import dev.qixils.relocated.annotations.Blocking;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.sheep.Sheep;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;

public class SummonEntityCommand<E extends Entity>
extends ModdedCommand
implements EntityCommand<E> {
    private static final Set<EquipmentSlot> HANDS = Arrays.stream(EquipmentSlot.values()).filter(slot -> slot.getType() == EquipmentSlot.Type.HAND).collect(Collectors.toSet());
    protected final EntityType<? extends E> entityType;
    protected final EntityType<? extends E>[] entityTypes;
    private final String effectName;
    private final Component displayName;
    private final String image = "entity_creeper";
    private final int price;
    private final byte priority = (byte)5;
    private final List<String> categories = Collections.singletonList("Summon Entity");
    private static List<ResourceKey<LootTable>> LOOT_TABLES = null;
    private static final Map<EntityType<?>, List<Item>> HORSE_ARMOR = new HashMap();
    private static final Map<Rabbit.Variant, Integer> RABBIT_VARIANTS = Map.of(Rabbit.Variant.BLACK, 16, Rabbit.Variant.BROWN, 16, Rabbit.Variant.GOLD, 16, Rabbit.Variant.SALT, 16, Rabbit.Variant.WHITE, 16, Rabbit.Variant.WHITE_SPLOTCHED, 16, Rabbit.Variant.EVIL, 1);
    private static final Map<EquipmentSlot, List<Item>> HUMANOID_ARMOR;

    public SummonEntityCommand(ModdedCrowdControlPlugin plugin, EntityType<E> entityType) {
        this(plugin, "entity_" + CommandConstants.csIdOf((Keyed)BuiltInRegistries.ENTITY_TYPE.getKey(entityType)), (Component)Component.translatable((String)"cc.effect.summon_entity.name", (ComponentLike[])new ComponentLike[]{plugin.toAdventure(entityType.getDescription())}), entityType, new EntityType[0]);
    }

    @SafeVarargs
    public SummonEntityCommand(ModdedCrowdControlPlugin plugin, String effectName, @Nullable Component displayName, EntityType<? extends E> firstEntity, EntityType<? extends E> ... otherEntities) {
        super(plugin);
        this.entityType = firstEntity;
        this.entityTypes = new EntityType[1 + otherEntities.length];
        this.entityTypes[0] = firstEntity;
        System.arraycopy(otherEntities, 0, this.entityTypes, 1, otherEntities.length);
        this.effectName = effectName;
        this.displayName = displayName;
        int _price = 500;
        try {
            if (firstEntity.create((Level)plugin.server().overworld(), EntitySpawnReason.COMMAND) instanceof Enemy) {
                _price = 1000;
            }
        }
        catch (Exception e) {
            plugin.getSLF4JLogger().debug("Could not generate default price for {}", (Object)BuiltInRegistries.ENTITY_TYPE.getKey(firstEntity), (Object)e);
        }
        this.price = _price;
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        return this.getDefaultDisplayName();
    }

    public EntityType<? extends E> getRandomEntityType() {
        return RandomUtil.randomElementFrom(this.entityTypes);
    }

    private static List<ResourceKey<LootTable>> getLOOT_TABLES(MinecraftServer server) {
        if (LOOT_TABLES != null) {
            return LOOT_TABLES;
        }
        LOOT_TABLES = server.reloadableRegistries().lookup().lookupOrThrow(Registries.LOOT_TABLE).listElementIds().filter(key -> key.location().getPath().startsWith("chests/")).toList();
        return LOOT_TABLES;
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            List players = (List)playerSupplier.get();
            LimitConfig config = this.getPlugin().getLimitConfig();
            int playerLimit = config.getEntityLimit(this.getEffectName().replace("entity_", ""));
            CCEffectResponse tryExecute = this.tryExecute(players, request, ccPlayer);
            if (tryExecute != null) {
                return tryExecute;
            }
            Component name = this.plugin.getViewerComponentOrNull(request, false);
            return this.executeLimit(request, players, playerLimit, player -> CompletableFuture.supplyAsync(() -> {
                boolean success = false;
                try {
                    success = this.spawnEntity(name, (ServerPlayer)player) != null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return success ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_PERMANENT, "Failed to spawn entity");
            }, this.getPlugin().getSyncExecutor()).join());
        }));
    }

    @Blocking
    protected static <E extends Entity> E spawnEntity(@Nullable Component viewer, @NotNull ServerPlayer player, @NotNull EntityType<E> entityType, @NotNull ModdedCrowdControlPlugin plugin) {
        LivingEntity livingEntity;
        ServerLevel level = player.level();
        if (entityType == EntityType.ENDER_DRAGON && level.getDragonFight() != null) {
            return null;
        }
        Entity entity = entityType.create((Level)player.level(), EntitySpawnReason.COMMAND);
        if (entity == null) {
            throw new IllegalStateException("Could not spawn entity");
        }
        entity.setPos(player.position());
        if (viewer != null) {
            entity.setCustomName(plugin.toNative(viewer, (Pointered)player));
            entity.setCustomNameVisible(true);
        }
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(entity.blockPosition()), EntitySpawnReason.COMMAND, null);
        }
        if (entity instanceof TamableAnimal) {
            TamableAnimal tamable = (TamableAnimal)entity;
            tamable.tame((Player)player);
        }
        if (entity instanceof LivingEntity) {
            livingEntity = (LivingEntity)entity;
            livingEntity.cc$setViewerSpawned();
        }
        if (entity instanceof Wolf) {
            Wolf wolf = (Wolf)entity;
            wolf.setCollarColor(RandomUtil.randomElementFrom(DyeColor.values()));
            wolf.setVariant((Holder)RandomUtil.randomElementFrom(level.registryAccess().lookupOrThrow(Registries.WOLF_VARIANT).listElements()));
        }
        if (entity instanceof MushroomCow) {
            MushroomCow mooshroom = (MushroomCow)entity;
            if (RandomUtil.RNG.nextDouble() < 0.01) {
                mooshroom.setVariant(MushroomCow.Variant.BROWN);
            }
        }
        if (entity instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)entity;
            if (horse.canUseSlot(EquipmentSlot.BODY) && RandomUtil.RNG.nextBoolean()) {
                List items = HORSE_ARMOR.computeIfAbsent(entityType, $ -> BuiltInRegistries.ITEM.stream().filter(item -> {
                    Equippable equippable = (Equippable)item.components().get(DataComponents.EQUIPPABLE);
                    if (equippable == null) {
                        return false;
                    }
                    return equippable.slot().getType() == EquipmentSlot.Type.ANIMAL_ARMOR;
                }).toList());
                horse.getSlot(401).set(new ItemStack((ItemLike)RandomUtil.randomElementFrom(items)));
            }
            horse.setOwner((LivingEntity)player);
            horse.setTamed(true);
        }
        if (entity instanceof Sheep) {
            Sheep sheep = (Sheep)entity;
            sheep.setColor(RandomUtil.randomElementFrom(DyeColor.values()));
        }
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).canUseSlot(EquipmentSlot.SADDLE) && RandomUtil.RNG.nextBoolean()) {
            livingEntity.setItemSlot(EquipmentSlot.SADDLE, new ItemStack((ItemLike)Items.SADDLE));
        }
        if (entity instanceof EnderMan) {
            EnderMan enderman = (EnderMan)entity;
            enderman.setCarriedBlock(((Block)RandomUtil.randomElementFrom(BuiltInRegistries.BLOCK)).defaultBlockState());
        }
        if (entity instanceof AbstractChestedHorse) {
            AbstractChestedHorse chested = (AbstractChestedHorse)entity;
            chested.setChest(RandomUtil.RNG.nextBoolean());
        }
        if (entity instanceof Frog) {
            Frog frog = (Frog)entity;
            frog.setVariant((Holder)RandomUtil.randomElementFrom(level.registryAccess().lookupOrThrow(Registries.FROG_VARIANT).listElements()));
        }
        if (entity instanceof Axolotl) {
            Axolotl axolotl = (Axolotl)entity;
            axolotl.setVariant(RandomUtil.randomElementFrom(Axolotl.Variant.values()));
        }
        if (entity instanceof Rabbit) {
            Rabbit rabbit = (Rabbit)entity;
            rabbit.setVariant(RandomUtil.weightedRandom(RABBIT_VARIANTS));
        }
        if (entity instanceof VillagerDataHolder) {
            VillagerDataHolder villager = (VillagerDataHolder)entity;
            villager.setVillagerData(villager.getVillagerData().withType((Holder)RandomUtil.randomElementFrom(BuiltInRegistries.VILLAGER_TYPE.listElements())));
        }
        if (entity instanceof ContainerEntity) {
            ContainerEntity container = (ContainerEntity)entity;
            container.setContainerLootTable(RandomUtil.randomElementFrom(SummonEntityCommand.getLOOT_TABLES(level.getServer())));
        }
        if (entity instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)entity;
            ArrayList<EquipmentSlot> slots = new ArrayList<EquipmentSlot>(HUMANOID_ARMOR.keySet());
            Collections.shuffle(slots, random);
            int odds = 4;
            for (EquipmentSlot type : slots) {
                if (random.nextInt(odds) > 0) continue;
                ItemStack item = new ItemStack((ItemLike)RandomUtil.randomElementFrom(HUMANOID_ARMOR.get(type)));
                plugin.commandRegister().getCommandByName("lootbox", LootboxCommand.class).randomlyModifyItem(item, (odds += 2) / 4, level.registryAccess());
                armorStand.setItemSlot(type, item);
            }
            if (RandomUtil.RNG.nextBoolean()) {
                armorStand.setShowArms(true);
                for (EquipmentSlot slot : HANDS) {
                    if (!RandomUtil.RNG.nextBoolean()) continue;
                    armorStand.setItemSlot(slot, plugin.commandRegister().getCommandByName("lootbox", LootboxCommand.class).createRandomItem(RandomUtil.RNG.nextInt(6), level.registryAccess()));
                }
            }
        }
        level.addFreshEntity(entity);
        return (E)entity;
    }

    @Blocking
    protected E spawnEntity(@Nullable Component viewer, @NotNull ServerPlayer player) {
        return SummonEntityCommand.spawnEntity(viewer, player, this.getRandomEntityType(), this.plugin);
    }

    @Override
    @Generated
    public EntityType<? extends E> getEntityType() {
        return this.entityType;
    }

    @Generated
    public EntityType<? extends E>[] getEntityTypes() {
        return this.entityTypes;
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }

    @Override
    @Generated
    public String getImage() {
        return this.image;
    }

    @Override
    @Generated
    public int getPrice() {
        return this.price;
    }

    @Override
    @Generated
    public byte getPriority() {
        return this.priority;
    }

    @Override
    @Generated
    public List<String> getCategories() {
        return this.categories;
    }

    static {
        HashMap armor = new HashMap(4);
        for (Item item : BuiltInRegistries.ITEM) {
            EquipmentSlot slot2;
            Equippable equippable = (Equippable)item.components().get(DataComponents.EQUIPPABLE);
            if (equippable == null || (slot2 = equippable.slot()).getType() != EquipmentSlot.Type.HUMANOID_ARMOR) continue;
            armor.computeIfAbsent(slot2, $ -> new ArrayList()).add(item);
        }
        for (Map.Entry entry : new HashSet(armor.entrySet())) {
            armor.put((EquipmentSlot)entry.getKey(), Collections.unmodifiableList((List)entry.getValue()));
        }
        HUMANOID_ARMOR = Collections.unmodifiableMap(armor);
    }
}

